/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.hover;

import com.google.inject.Injector;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.hover.DotEObjectHover;
import org.eclipse.gef.dot.internal.ui.language.hover.DotHtmlLabelHoverFakeSourceViewer;
import org.eclipse.gef.dot.internal.ui.language.hover.DotHtmlLabelSubgrammarEObjectHover;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.ISourceViewerAware;
import org.eclipse.xtext.ui.editor.hover.IEObjectHover;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DotHtmlLabelAdaptingTextHover
extends DotEObjectHover {
    private final Injector injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
    private final ISourceViewer sourceViewer = new DotHtmlLabelHoverFakeSourceViewer();
    private final IEObjectHover hover;

    public DotHtmlLabelAdaptingTextHover() {
        IEObjectHover hover = (IEObjectHover)this.injector.getInstance(IEObjectHover.class);
        if (hover instanceof ISourceViewerAware) {
            ((ISourceViewerAware)hover).setSourceViewer(this.sourceViewer);
        }
        this.hover = hover;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        HtmlOffsetPair html = this.htmlOffsetPair(offset, textViewer);
        if (html == null) {
            return super.getHoverRegion(textViewer, offset);
        }
        ISourceViewer iSourceViewer = this.sourceViewer;
        synchronized (iSourceViewer) {
            try {
                this.sourceViewer.setDocument((IDocument)DotEditorUtils.getDocument(this.injector, html.code));
            }
            catch (Exception exception) {
                return super.getHoverRegion(textViewer, offset);
            }
            if (this.hover instanceof ITextHover) {
                IRegion htmlRegion = ((ITextHover)this.hover).getHoverRegion((ITextViewer)this.sourceViewer, offset - html.offset);
                return new Region(html.offset + htmlRegion.getOffset(), htmlRegion.getLength());
            }
        }
        return super.getHoverRegion(textViewer, offset);
    }

    private HtmlOffsetPair htmlOffsetPair(final int offset, ITextViewer textViewer) {
        IXtextDocument xtextDocument = XtextDocumentUtil.get((Object)textViewer);
        if (xtextDocument == null) {
            return null;
        }
        return (HtmlOffsetPair)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<HtmlOffsetPair, XtextResource>(){

            public HtmlOffsetPair exec(XtextResource state) throws Exception {
                if (state == null) {
                    return null;
                }
                Pair<EObject, IRegion> element = DotHtmlLabelAdaptingTextHover.this.getXtextElementAt(state, offset);
                if (element.getFirst() instanceof Attribute) {
                    String code = ((Attribute)element.getFirst()).getValue().toValue();
                    int offset2 = ((IRegion)element.getSecond()).getOffset() + ((IRegion)element.getSecond()).getLength() - 1 - code.length();
                    return new HtmlOffsetPair(code, offset2);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getHoverInfo(EObject eObject, ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer == null || hoverRegion == null) {
            return null;
        }
        HtmlOffsetPair html = this.htmlOffsetPair(hoverRegion.getOffset(), textViewer);
        if (html == null) {
            return null;
        }
        ISourceViewer iSourceViewer = this.sourceViewer;
        synchronized (iSourceViewer) {
            try {
                this.sourceViewer.setDocument((IDocument)DotEditorUtils.getDocument(this.injector, html.code));
            }
            catch (Exception exception) {
                return null;
            }
            Object hoverInfo = null;
            if (this.hover instanceof DotHtmlLabelSubgrammarEObjectHover && eObject instanceof Attribute) {
                ((DotHtmlLabelSubgrammarEObjectHover)this.hover).setContainingAttribute((Attribute)eObject);
            }
            if (this.hover instanceof ITextHoverExtension2) {
                hoverInfo = ((ITextHoverExtension2)this.hover).getHoverInfo2((ITextViewer)this.sourceViewer, (IRegion)new Region(hoverRegion.getOffset() - html.offset, hoverRegion.getLength()));
            }
            if (this.hover instanceof DotHtmlLabelSubgrammarEObjectHover) {
                this.lastCreatorProvider = ((DotHtmlLabelSubgrammarEObjectHover)this.hover).getLastCreatorProvider();
            }
            return hoverInfo;
        }
    }

    private static class HtmlOffsetPair {
        private String code;
        private int offset;

        private HtmlOffsetPair(String code, int offset) {
            this.code = code;
            this.offset = offset;
        }
    }
}

