/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionContainer;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.session.CDOViewContainerImpl;
import org.eclipse.emf.internal.cdo.transaction.CDOTransactionImpl;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;

public abstract class CDOTransactionContainerImpl
extends CDOViewContainerImpl
implements CDOTransactionContainer {
    public InternalCDOTransaction getTransaction(int viewID) {
        CDOView view = this.getView(viewID);
        if (view instanceof InternalCDOTransaction) {
            return (InternalCDOTransaction)view;
        }
        return null;
    }

    public InternalCDOTransaction[] getTransactions() {
        return this.getTransactions(null);
    }

    public InternalCDOTransaction[] getTransactions(CDOBranch branch) {
        List<InternalCDOView> transactions = this.getViews(branch, true);
        return transactions.toArray(new InternalCDOTransaction[transactions.size()]);
    }

    public CDOTransaction openTransaction(CDOBranchPoint target, ResourceSet resourceSet) {
        this.checkArg(target.getTimeStamp() == 0L, "Target is not head of a branch: " + target);
        return this.openTransaction(target.getBranch(), resourceSet);
    }

    public CDOTransaction openTransaction(CDOBranchPoint target) {
        return this.openTransaction(target, this.createResourceSet());
    }

    public InternalCDOTransaction openTransaction(CDOBranch branch, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(branch);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    public InternalCDOTransaction openTransaction(ResourceSet resourceSet) {
        return this.openTransaction(this.getMainBranch(), resourceSet);
    }

    public InternalCDOTransaction openTransaction(CDOBranch branch) {
        return this.openTransaction(branch, this.createResourceSet());
    }

    public InternalCDOTransaction openTransaction() {
        return this.openTransaction(this.getMainBranch());
    }

    public CDOTransaction openTransaction(String durableLockingID) {
        return this.openTransaction(durableLockingID, this.createResourceSet());
    }

    public CDOTransaction openTransaction(String durableLockingID, ResourceSet resourceSet) {
        this.checkActive();
        InternalCDOTransaction transaction = this.createTransaction(durableLockingID);
        this.initView(transaction, resourceSet);
        return transaction;
    }

    protected InternalCDOTransaction createTransaction(CDOBranch branch) {
        return TransactionCreator.instance.createTransaction((CDOSession)((Object)this), branch);
    }

    protected InternalCDOTransaction createTransaction(String durableLockingID) {
        return TransactionCreator.instance.createTransaction((CDOSession)((Object)this), durableLockingID);
    }

    public static class TransactionCreator {
        public static final TransactionCreator DEFAULT;
        private static TransactionCreator instance;

        static {
            instance = DEFAULT = new TransactionCreator();
        }

        public static void set(TransactionCreator creator) {
            instance = creator;
        }

        public static void reset() {
            instance = DEFAULT;
        }

        public InternalCDOTransaction createTransaction(CDOSession session, CDOBranch branch) {
            return new CDOTransactionImpl(session, branch);
        }

        public InternalCDOTransaction createTransaction(CDOSession session, String durableLockingID) {
            return new CDOTransactionImpl(session, durableLockingID);
        }
    }
}

