/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.net4j.protocol;

import java.io.IOException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.server.internal.net4j.bundle.OM;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.server.internal.net4j.protocol.CDOServerReadIndication;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class LoadObjectLifetimeIndication
extends CDOServerReadIndication {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_PROTOCOL, LoadObjectLifetimeIndication.class);
    private CDOID id;
    private CDOBranchPoint branchPoint;

    public LoadObjectLifetimeIndication(CDOServerProtocol protocol) {
        super(protocol, (short)59);
    }

    protected void indicating(CDODataInput in) throws IOException {
        this.id = in.readCDOID();
        if (TRACER.isEnabled()) {
            TRACER.format("Read id: {0}", new Object[]{this.id});
        }
        this.branchPoint = in.readCDOBranchPoint();
        if (TRACER.isEnabled()) {
            TRACER.format("Read branchPoint: {0}", new Object[]{this.branchPoint});
        }
    }

    protected void responding(CDODataOutput out) throws IOException {
        InternalCDORevisionManager revisionManager = this.getRepository().getRevisionManager();
        CDOBranchPointRange range = revisionManager.getObjectLifetime(this.id, this.branchPoint);
        CDOBranchUtil.writeRangeOrNull((CDODataOutput)out, (CDOBranchPointRange)range);
    }
}

