/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.extensions;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.edit.RLSServerInterface;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ReferenceContext;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileSearchResult;
import org.eclipse.search.internal.ui.text.LineElement;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class ImplementationsSearchQuery
extends FileSearchQuery {
    private final Position position;
    private final LanguageServiceAccessor.LSPDocumentInfo info;
    private final String filename;
    private FileSearchResult result;
    private long startTime;
    private CompletableFuture<List<Location>> references;

    public ImplementationsSearchQuery(int offset, LanguageServiceAccessor.LSPDocumentInfo info) throws BadLocationException {
        super("", false, false, null);
        this.position = LSPEclipseUtils.toPosition((int)offset, (IDocument)info.getDocument());
        this.info = info;
        IResource resource = LSPEclipseUtils.findResourceFor((String)info.getFileUri().toString());
        this.filename = resource != null ? resource.getName() : info.getFileUri().toString();
    }

    public IStatus run(IProgressMonitor monitor) {
        this.startTime = System.currentTimeMillis();
        if (this.references != null) {
            this.references.cancel(true);
        }
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        try {
            ReferenceParams params = new ReferenceParams();
            params.setContext(new ReferenceContext(true));
            params.setTextDocument(new TextDocumentIdentifier(this.info.getFileUri().toString()));
            params.setPosition(this.position);
            ((CompletableFuture)this.info.getInitializedLanguageClient().thenCompose(languageServer -> ((RLSServerInterface)languageServer).implementations((TextDocumentPositionParams)params))).thenAccept(locs -> {
                for (Location loc : locs) {
                    Match match = ImplementationsSearchQuery.toMatch(loc);
                    this.result.addMatch(match);
                }
            });
            return Status.OK_STATUS;
        }
        catch (Exception ex) {
            return new Status(4, LanguageServerPlugin.getDefault().getBundle().getSymbolicName(), ex.getMessage(), (Throwable)ex);
        }
    }

    private static Match toMatch(Location location) {
        try {
            IResource resource = LSPEclipseUtils.findResourceFor((String)location.getUri());
            IDocument document = LSPEclipseUtils.getDocument((IResource)resource);
            if (document != null) {
                int startOffset = LSPEclipseUtils.toOffset((Position)location.getRange().getStart(), (IDocument)document);
                int endOffset = LSPEclipseUtils.toOffset((Position)location.getRange().getEnd(), (IDocument)document);
                IRegion lineInformation = document.getLineInformationOfOffset(startOffset);
                LineElement lineEntry = new LineElement(resource, document.getLineOfOffset(startOffset), lineInformation.getOffset(), document.get(lineInformation.getOffset(), lineInformation.getLength()));
                return new FileMatch((IFile)resource, startOffset, endOffset - startOffset, lineEntry);
            }
            Position startPosition = location.getRange().getStart();
            LineElement lineEntry = new LineElement(resource, startPosition.getLine(), 0, String.format("%s:%s", startPosition.getLine(), startPosition.getCharacter()));
            return new FileMatch((IFile)resource, 0, 0, lineEntry);
        }
        catch (BadLocationException ex) {
            LanguageServerPlugin.logError((Throwable)ex);
            return null;
        }
    }

    public ISearchResult getSearchResult() {
        if (this.result == null) {
            this.result = new FileSearchResult((FileSearchQuery)this);
        }
        return this.result;
    }

    public String getLabel() {
        return Messages.ImplementationsSearchQuery_implementations;
    }

    public String getResultLabel(int nMatches) {
        long time = 0L;
        if (this.startTime > 0L) {
            time = System.currentTimeMillis() - this.startTime;
        }
        if (nMatches == 1) {
            return NLS.bind((String)Messages.ImplementationsSearchQuery_oneReference, (Object[])new Object[]{this.filename, this.position.getLine() + 1, this.position.getCharacter() + 1, time});
        }
        return NLS.bind((String)Messages.ImplementationsSearchQuery_severalReferences, (Object[])new Object[]{this.filename, this.position.getLine() + 1, this.position.getCharacter() + 1, nMatches, time});
    }

    public boolean isFileNameSearch() {
        return false;
    }
}

