/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.template;

import org.eclipse.cdt.internal.ui.text.template.TemplateMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;

public class TemplateVariableProposal
implements ICompletionProposal {
    private TemplateVariableResolver fResolver;
    private int fOffset;
    private int fLength;
    private ITextViewer fViewer;
    private Point fSelection;
    private final boolean fIncludeBrace;

    public TemplateVariableProposal(TemplateVariableResolver variable, int offset, int length, ITextViewer viewer, boolean includeBrace) {
        this.fResolver = variable;
        this.fOffset = offset;
        this.fLength = length;
        this.fViewer = viewer;
        this.fIncludeBrace = includeBrace;
    }

    public void apply(IDocument document) {
        try {
            String type = this.fResolver.getType();
            String variable = type.equals("dollar") ? "$$" : (this.fIncludeBrace ? "${" + type + '}' : type);
            document.replace(this.fOffset, this.fLength, variable);
            this.fSelection = new Point(this.fOffset + variable.length(), 0);
        }
        catch (BadLocationException e) {
            CUIPlugin.log(e);
            Shell shell = this.fViewer.getTextWidget().getShell();
            MessageDialog.openError((Shell)shell, (String)TemplateMessages.TemplateVariableProposal_error_title, (String)e.getMessage());
        }
    }

    public Point getSelection(IDocument document) {
        return this.fSelection;
    }

    public String getAdditionalProposalInfo() {
        return this.fResolver.getDescription();
    }

    public String getDisplayString() {
        return this.fResolver.getType();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

