/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

public class MIDisplayHint {
    public static final MIDisplayHint NONE = new MIDisplayHint(GdbDisplayHint.GDB_DISPLAY_HINT_NONE, "");
    private final GdbDisplayHint gdbHint;
    private final String displayHint;

    private MIDisplayHint(GdbDisplayHint gdbHint, String hint) {
        this.gdbHint = gdbHint;
        this.displayHint = hint;
    }

    public MIDisplayHint(String text) {
        this.gdbHint = MIDisplayHint.parseDisplayHint(text);
        this.displayHint = text.trim();
    }

    public String getDisplayHint() {
        return this.displayHint;
    }

    public GdbDisplayHint getGdbDisplayHint() {
        return this.gdbHint;
    }

    public boolean isCollectionHint() {
        switch (this.getGdbDisplayHint()) {
            case GDB_DISPLAY_HINT_ARRAY: 
            case GDB_DISPLAY_HINT_MAP: {
                return true;
            }
        }
        return false;
    }

    private static GdbDisplayHint parseDisplayHint(String text) {
        String hint = text.trim();
        GdbDisplayHint[] gdbDisplayHintArray = GdbDisplayHint.values();
        int n = gdbDisplayHintArray.length;
        int n2 = 0;
        while (n2 < n) {
            GdbDisplayHint gdbHint = gdbDisplayHintArray[n2];
            String miToken = gdbHint.getMIToken();
            if (miToken != null && miToken.equals(hint)) {
                return gdbHint;
            }
            ++n2;
        }
        return GdbDisplayHint.GDB_DISPLAY_USER_DEFINED;
    }

    public static enum GdbDisplayHint {
        GDB_DISPLAY_HINT_NONE(null),
        GDB_DISPLAY_HINT_STRING("string"),
        GDB_DISPLAY_HINT_ARRAY("array"),
        GDB_DISPLAY_HINT_MAP("map"),
        GDB_DISPLAY_USER_DEFINED(null);

        private final String miToken;

        private GdbDisplayHint(String miToken) {
            this.miToken = miToken;
        }

        public String getMIToken() {
            return this.miToken;
        }
    }
}

