/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.typesystem.xsd.builder;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xtend.typesystem.xsd.builder.OawXSDResource;
import org.eclipse.xtend.typesystem.xsd.util.Msg;
import org.eclipse.xtend.typesystem.xsd.util.XSDLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawXSDEcoreBuilder
extends XSDEcoreBuilder {
    protected Log log = XSDLog.getLog(((Object)((Object)this)).getClass());

    public OawXSDEcoreBuilder(ExtendedMetaData extendedMetaData) {
        super(extendedMetaData);
    }

    private String checkAttribute(XSDConcreteComponent comp, String attr, String val) {
        if ("package".equals(attr) && val.contains(".")) {
            return val.substring(val.lastIndexOf(".") + 1);
        }
        return val;
    }

    public void copy(OawXSDEcoreBuilder b) {
        this.xsdSchemas.addAll(b.xsdSchemas);
        this.xsdComponentToEModelElementMap.putAll(b.xsdComponentToEModelElementMap);
        this.targetNamespaceToEPackageMap.putAll(b.targetNamespaceToEPackageMap);
        this.eReferenceToKeyNamesMap.putAll(b.eReferenceToKeyNamesMap);
        this.eReferenceToOppositeNameMap.putAll(b.eReferenceToOppositeNameMap);
        this.typeToTypeObjectMap.putAll(b.typeToTypeObjectMap);
    }

    public void generate(XSDSchema xsdSchema) {
        super.generate(xsdSchema);
    }

    private String getCustomAttribute(XSDConcreteComponent comp, String attr) {
        String pkg;
        if ("documentRoot".equals(attr) && (pkg = this.getPkgName((EObject)comp)) != null && !"".equals(pkg)) {
            pkg = String.valueOf(pkg.substring(0, 1).toUpperCase()) + pkg.substring(1);
            return String.valueOf(pkg) + "DocumentRoot";
        }
        return null;
    }

    protected String getEcoreAttribute(XSDConcreteComponent xsdConcreteComponent, String attribute) {
        String r = super.getEcoreAttribute(xsdConcreteComponent, attribute);
        if (r != null && !"".equals(r)) {
            return this.checkAttribute(xsdConcreteComponent, attribute, r);
        }
        return this.getCustomAttribute(xsdConcreteComponent, attribute);
    }

    public EPackage getEPackage(XSDNamedComponent xsdNamedComponent) {
        XSDSchema containingXSDSchema = xsdNamedComponent.getSchema();
        String targetNamespace = containingXSDSchema == null ? xsdNamedComponent.getTargetNamespace() : containingXSDSchema.getTargetNamespace();
        boolean isNew = this.targetNamespaceToEPackageMap.get(targetNamespace) == null;
        EPackage ePackage = super.getEPackage(xsdNamedComponent);
        if (isNew) {
            this.initEPackage(containingXSDSchema, ePackage);
        }
        return ePackage;
    }

    protected boolean isUppercase(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isLowerCase(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected String validName(String name, int casing, String prefix) {
        List parsedName = this.parseName(name, '_');
        StringBuffer result = new StringBuffer();
        for (String nameComponent : parsedName) {
            if (nameComponent.length() <= 0) continue;
            if (casing != 0 && this.isUppercase(nameComponent)) {
                nameComponent = nameComponent.toLowerCase();
            }
            if (result.length() > 0 || casing == 1) {
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
                continue;
            }
            result.append(nameComponent);
        }
        return result.length() == 0 ? prefix : (Character.isJavaIdentifierStart(result.charAt(0)) ? (casing == 2 ? this.uncapName(result.toString()) : result.toString()) : String.valueOf(prefix) + result);
    }

    private String getPkgName(EObject obj) {
        if (obj.eResource() == null || obj.eResource().getURI() == null) {
            return null;
        }
        return this.validName(obj.eResource().getURI().trimFileExtension().lastSegment(), false);
    }

    protected void initEPackage(XSDSchema schema, EPackage pkg) {
        if (schema.getTargetNamespace() != null && !schema.getTargetNamespace().equals("") && !schema.getTargetNamespace().equals(this.rootSchema.getTargetNamespace())) {
            throw new RuntimeException(Msg.create("The OawXSDEcoreBuilder has to be called for every EPackage explicitly. Schema:").schema(schema).txt(" Root:").schema(this.rootSchema).txt(" ").schemas(this.xsdSchemas).toString());
        }
        String name = this.getPkgName((EObject)this.rootSchema);
        if (name != null) {
            pkg.setName(name);
        }
        OawXSDResource res = (OawXSDResource)this.rootSchema.eResource();
        res.setEcorePackage(pkg);
        this.log.info((Object)Msg.create("Creating EPackage ").pkg(pkg.getName()).txt(" from ").schemaDeep(this.rootSchema));
    }

    protected void resolveNameConflict(Map<String, ? extends ENamedElement> map, ENamedElement namedElement, String suffix) {
        ENamedElement confl;
        String name = namedElement.getName();
        if (!name.endsWith(suffix)) {
            name = String.valueOf(name) + suffix;
        }
        if ((confl = map.get(name.toLowerCase())) != null) {
            int index = 0;
            while (map.containsKey(String.valueOf(name.toLowerCase()) + ++index)) {
            }
            namedElement.setName(String.valueOf(name) + index);
            Msg m = Msg.create("Name Conflict: Created ").sclsname((EObject)namedElement).txt(", ").sclsname((EObject)confl).txt(" is in the way.");
            m = confl.eContainer() == namedElement.eContainer() ? m.txt(" Container:").path(confl.eContainer()) : m.txt(" Container1:").path(confl.eContainer()).txt(", Container2:").path(namedElement.eContainer());
            this.log.warn((Object)m);
        } else {
            namedElement.setName(name);
        }
    }
}

