/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import org.eclipse.wst.common.uriresolver.internal.URI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;

public class URIUtils {
    private static final String PROTOCOL_PATTERN = ":";
    private static final String FILE_PROTOCOL = "file:";
    private static final String PLATFORM_RESOURCE_PROTOCOL = "platform:/resource/";
    private static final String LOCAL_FILE_PROTOCOL_FORWARD_SLASH = "\\\\\\";
    private static final String LOCAL_FILE_PROTOCOL_BACK_SLASH = "///";
    private static final char PATH_SEPARATOR_FORWARD_SLASH = '/';
    private static final char PATH_SEPARATOR_BACK_SLASH = '\\';

    public static String convertURIToLocation(String uri) {
        String location = uri;
        if (uri != null) {
            if (uri.startsWith(FILE_PROTOCOL)) {
                location = URI.createURI((String)uri).toFileString();
                if (location != null && (location.startsWith(LOCAL_FILE_PROTOCOL_BACK_SLASH) || location.startsWith(LOCAL_FILE_PROTOCOL_FORWARD_SLASH))) {
                    location = location.substring(LOCAL_FILE_PROTOCOL_BACK_SLASH.length());
                }
            } else if (uri.startsWith(PLATFORM_RESOURCE_PROTOCOL)) {
                location = uri.substring(PLATFORM_RESOURCE_PROTOCOL.length());
            }
        }
        return location;
    }

    public static String convertLocationToURI(String location) {
        String uri = location;
        if (!URIHelper.hasProtocol((String)location)) {
            String string = uri = URIHelper.isAbsolute((String)location) ? URI.createFileURI((String)location).toString() : URIHelper.prependPlatformResourceProtocol((String)location);
        }
        if (uri.startsWith(FILE_PROTOCOL) && uri.indexOf(PROTOCOL_PATTERN, FILE_PROTOCOL.length()) != -1) {
            uri = URIHelper.ensureFileURIProtocolFormat((String)uri);
        }
        uri = uri.replace('\\', '/');
        return uri;
    }
}

