/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.Location;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.BreakpointRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.DebuggerStatementRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequestManager;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ExceptionRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ResumeRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.StepRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.SuspendRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadExitRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDeathRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.VMDisconnectRequest;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.VirtualMachineImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.BreakpointRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.DebuggerStatementRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.EventRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.ExceptionRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.ResumeRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.ScriptLoadRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.StepRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.SuspendRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.ThreadEnterRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.ThreadExitRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.VMDeathRequestImpl;
import org.eclipse.wst.jsdt.debug.internal.rhino.jsdi.request.VMDisconnectRequestImpl;

public final class EventRequestManagerImpl
implements EventRequestManager {
    private final Map eventsMap = new HashMap();
    private final List breakpointRequests = new ArrayList();
    private final List exceptionRequests = new ArrayList();
    private final List debuggerStatementRequests = new ArrayList();
    private final List scriptLoadRequests = new ArrayList();
    private final List stepRequests = new ArrayList();
    private final List suspendRequests = new ArrayList();
    private final List resumeRequests = new ArrayList();
    private final List threadEnterRequests = new ArrayList();
    private final List threadExitRequests = new ArrayList();
    private final List vmDeathRequests = new ArrayList();
    private final List vmDisconnectRequests = new ArrayList();
    private final VirtualMachineImpl vm;

    public EventRequestManagerImpl(VirtualMachineImpl vm) {
        this.vm = vm;
        this.eventsMap.put(BreakpointRequestImpl.class, this.breakpointRequests);
        this.eventsMap.put(DebuggerStatementRequestImpl.class, this.debuggerStatementRequests);
        this.eventsMap.put(ExceptionRequestImpl.class, this.exceptionRequests);
        this.eventsMap.put(ScriptLoadRequestImpl.class, this.scriptLoadRequests);
        this.eventsMap.put(StepRequestImpl.class, this.stepRequests);
        this.eventsMap.put(SuspendRequestImpl.class, this.suspendRequests);
        this.eventsMap.put(ResumeRequestImpl.class, this.resumeRequests);
        this.eventsMap.put(ThreadEnterRequestImpl.class, this.threadEnterRequests);
        this.eventsMap.put(ThreadExitRequestImpl.class, this.threadExitRequests);
        this.eventsMap.put(VMDeathRequestImpl.class, this.vmDeathRequests);
        this.eventsMap.put(VMDisconnectRequestImpl.class, this.vmDisconnectRequests);
    }

    public synchronized BreakpointRequest createBreakpointRequest(Location location) {
        BreakpointRequestImpl request = new BreakpointRequestImpl(this.vm, location);
        this.breakpointRequests.add(request);
        return request;
    }

    public synchronized List debuggerStatementRequests() {
        return Collections.unmodifiableList(this.debuggerStatementRequests);
    }

    public synchronized DebuggerStatementRequest createDebuggerStatementRequest() {
        DebuggerStatementRequestImpl request = new DebuggerStatementRequestImpl(this.vm);
        this.debuggerStatementRequests.add(request);
        return request;
    }

    public synchronized List breakpointRequests() {
        return Collections.unmodifiableList(this.breakpointRequests);
    }

    public synchronized ExceptionRequest createExceptionRequest() {
        ExceptionRequestImpl request = new ExceptionRequestImpl(this.vm);
        this.exceptionRequests.add(request);
        return request;
    }

    public synchronized List exceptionRequests() {
        return Collections.unmodifiableList(this.exceptionRequests);
    }

    public synchronized ScriptLoadRequest createScriptLoadRequest() {
        ScriptLoadRequestImpl request = new ScriptLoadRequestImpl(this.vm);
        this.scriptLoadRequests.add(request);
        return request;
    }

    public synchronized List scriptLoadRequests() {
        return Collections.unmodifiableList(this.scriptLoadRequests);
    }

    public synchronized StepRequest createStepRequest(ThreadReference thread, int step) {
        StepRequestImpl request = new StepRequestImpl(this.vm, thread, step);
        this.stepRequests.add(request);
        return request;
    }

    public synchronized List stepRequests() {
        return Collections.unmodifiableList(this.stepRequests);
    }

    public synchronized SuspendRequest createSuspendRequest(ThreadReference thread) {
        SuspendRequestImpl request = new SuspendRequestImpl(this.vm, thread);
        this.suspendRequests.add(request);
        return request;
    }

    public synchronized List suspendRequests() {
        return Collections.unmodifiableList(this.suspendRequests);
    }

    public ResumeRequest createResumeRequest(ThreadReference thread) {
        ResumeRequestImpl request = new ResumeRequestImpl(this.vm, thread);
        this.resumeRequests.add(request);
        return request;
    }

    public List resumeRequests() {
        return Collections.unmodifiableList(this.resumeRequests);
    }

    public synchronized ThreadEnterRequest createThreadEnterRequest() {
        ThreadEnterRequestImpl request = new ThreadEnterRequestImpl(this.vm);
        this.threadEnterRequests.add(request);
        return request;
    }

    public List threadEnterRequests() {
        return Collections.unmodifiableList(this.threadEnterRequests);
    }

    public synchronized ThreadExitRequest createThreadExitRequest() {
        ThreadExitRequestImpl request = new ThreadExitRequestImpl(this.vm);
        this.threadExitRequests.add(request);
        return request;
    }

    public List threadExitRequests() {
        return Collections.unmodifiableList(this.threadExitRequests);
    }

    public synchronized void deleteEventRequest(EventRequest eventRequest) {
        Class<?> clazz = eventRequest.getClass();
        List eventList = (List)this.eventsMap.get(clazz);
        if (eventList == null) {
            throw new IllegalArgumentException("bad event request class - " + clazz.getName());
        }
        eventList.remove(eventRequest);
        EventRequestImpl eventRequestImpl = (EventRequestImpl)eventRequest;
        eventRequestImpl.delete();
    }

    public synchronized void deleteEventRequest(List eventRequests) {
        for (EventRequest eventRequest : eventRequests) {
            this.deleteEventRequest(eventRequest);
        }
    }

    public VMDeathRequest createVMDeathRequest() {
        VMDeathRequestImpl request = new VMDeathRequestImpl(this.vm);
        this.vmDeathRequests.add(request);
        return request;
    }

    public List vmDeathRequests() {
        return Collections.unmodifiableList(this.vmDeathRequests);
    }

    public VMDisconnectRequest createVMDisconnectRequest() {
        VMDisconnectRequestImpl request = new VMDisconnectRequestImpl(this.vm);
        this.vmDisconnectRequests.add(request);
        return request;
    }

    public List vmDisconnectRequests() {
        return Collections.unmodifiableList(this.vmDisconnectRequests);
    }
}

