/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoImageRegistry;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.Messages;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.refactoring.Refactoring;
import org.eclipse.wst.jsdt.debug.internal.ui.SWTFactory;
import org.eclipse.wst.jsdt.debug.internal.ui.dialogs.ScriptSelectionDialog;

public class RhinoMainTab
extends AbstractLaunchConfigurationTab {
    public static final String TAB_ID = "rhino.main.tab";
    public static final String[] VERSIONS = new String[]{"100", "110", "120", "130", "140", "150", "160", "170"};
    public static final String[] OPTIMIZATIONS = new String[]{"-1 [interpret only]", "0 [no optimizations]", "1 [all optimizations]"};
    SelectionAdapter defaultAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            RhinoMainTab.this.updateLaunchConfigurationDialog();
        }
    };
    Text script = null;
    Button logging = null;
    Button strict = null;
    Combo ecmaversion = null;
    Combo optlevel = null;

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)768);
        Group group = SWTFactory.createGroup((Composite)comp, (String)Messages._script, (int)2, (int)1, (int)768);
        this.script = SWTFactory.createSingleText((Composite)group, (int)1);
        this.script.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RhinoMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.script.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.RhinoMainTab_1;
            }
        });
        ((GridData)this.script.getLayoutData()).grabExcessHorizontalSpace = true;
        Button browse = SWTFactory.createPushButton((Composite)group, (String)Messages.bro_wse, null);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IJavaScriptUnit unit = RhinoMainTab.this.chooseScript();
                if (unit != null) {
                    RhinoMainTab.this.script.setText(unit.getPath().toString());
                }
            }
        });
        group = SWTFactory.createGroup((Composite)comp, (String)Messages.options_group_name, (int)2, (int)1, (int)768);
        Label lbl = SWTFactory.createWrapLabel((Composite)group, (String)Messages.ecma_version_to_interpret_with, (int)1);
        ((GridData)lbl.getLayoutData()).grabExcessHorizontalSpace = true;
        this.ecmaversion = SWTFactory.createCombo((Composite)group, (int)12, (int)1, (String[])VERSIONS);
        this.ecmaversion.addSelectionListener((SelectionListener)this.defaultAdapter);
        GridData data = (GridData)this.ecmaversion.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 0x1000008;
        lbl = SWTFactory.createWrapLabel((Composite)group, (String)Messages.rhino_opt_level, (int)1);
        ((GridData)lbl.getLayoutData()).grabExcessHorizontalSpace = true;
        this.optlevel = SWTFactory.createCombo((Composite)group, (int)12, (int)1, (String[])OPTIMIZATIONS);
        this.optlevel.addSelectionListener((SelectionListener)this.defaultAdapter);
        data = (GridData)this.optlevel.getLayoutData();
        data.grabExcessHorizontalSpace = false;
        data.horizontalAlignment = 0x1000008;
        this.strict = SWTFactory.createCheckButton((Composite)group, (String)Messages.strict_mode, null, (boolean)false, (int)2);
        this.strict.addSelectionListener((SelectionListener)this.defaultAdapter);
        this.logging = SWTFactory.createCheckButton((Composite)group, (String)Messages.log_interpreter_exceptions, null, (boolean)false, (int)2);
        this.logging.addSelectionListener((SelectionListener)this.defaultAdapter);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.wst.jsdt.debug.rhino.ui.rhino_main_tab_context");
        this.setControl((Control)comp);
    }

    public String getHelpContextId() {
        return "org.eclipse.wst.jsdt.debug.rhino.ui.rhino_main_tab_context";
    }

    IJavaScriptUnit chooseScript() {
        ScriptSelectionDialog dialog = new ScriptSelectionDialog(this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setTitle(Messages.script_selection);
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            return (IJavaScriptUnit)JavaScriptCore.create((IFile)file);
        }
        return null;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean hasscript;
        String text2 = this.script.getText().trim();
        boolean bl = hasscript = text2.length() > 0;
        if (!hasscript) {
            this.setErrorMessage(Messages.provide_script_for_project);
            return false;
        }
        IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(text2));
        if (resource != null) {
            if (resource.getType() != 1) {
                this.setErrorMessage(NLS.bind((String)Messages.script_not_a_file, (Object)text2));
                return false;
            }
            if (!resource.isAccessible()) {
                this.setErrorMessage(NLS.bind((String)Messages.script_not_accessible, (Object)text2));
                return false;
            }
        } else {
            this.setErrorMessage(NLS.bind((String)Messages.script_not_in_workspace, (Object)text2));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(Messages.launch_script);
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        Object element = this.getContext();
        if (element != null) {
            String pname;
            if (element instanceof IMember) {
                IMember member = (IMember)element;
                element = member.isBinary() ? member.getClassFile() : member.getJavaScriptUnit();
            }
            String name = pname = element.getJavaScriptProject().getProject().getName();
            ITypeRoot root = null;
            if (element.getElementType() == 6 || element.getElementType() == 5) {
                root = (ITypeRoot)element;
                String tname = root.getElementName();
                configuration.setAttribute("script", root.getPath().toString());
                name = NLS.bind((String)Messages.config_name, (Object[])new String[]{pname, tname});
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            configuration.rename(name);
            Refactoring.mapResources(configuration);
        }
        configuration.setAttribute("logexceptions", true);
        configuration.setAttribute("ecmaversion", "170");
        configuration.setAttribute("optlevel", -1);
        configuration.setAttribute("strictmode", false);
    }

    IJavaScriptElement getContext() {
        IWorkbenchPage page = RhinoUIPlugin.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IJavaScriptElement) {
                    return (IJavaScriptElement)obj;
                }
                if (obj instanceof IResource) {
                    IJavaScriptElement je = JavaScriptCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = JavaScriptCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                return (IJavaScriptElement)input.getAdapter(IJavaScriptElement.class);
            }
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String text = configuration.getAttribute("script", null);
            if (text != null) {
                this.script.setText(text);
            } else {
                this.script.setText("");
            }
            boolean value = configuration.getAttribute("logexceptions", true);
            this.logging.setSelection(value);
            value = configuration.getAttribute("strictmode", false);
            this.strict.setSelection(value);
            text = configuration.getAttribute("ecmaversion", "170");
            int idx = this.ecmaversion.indexOf(text);
            if (idx < 0) {
                idx = 7;
            }
            this.ecmaversion.select(idx);
            int opt = configuration.getAttribute("optlevel", -1);
            this.optlevel.select(opt + 1);
        }
        catch (CoreException coreException) {}
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String scpt = this.script.getText().trim();
        if (scpt.length() < 1) {
            configuration.removeAttribute("script");
        } else {
            configuration.setAttribute("script", scpt);
        }
        configuration.setAttribute("logexceptions", this.logging.getSelection());
        configuration.setAttribute("strictmode", this.strict.getSelection());
        configuration.setAttribute("ecmaversion", this.ecmaversion.getText());
        configuration.setAttribute("optlevel", this.optlevel.getSelectionIndex() - 1);
        Refactoring.mapResources(configuration);
    }

    public String getName() {
        return Messages.main;
    }

    public String getId() {
        return TAB_ID;
    }

    public Image getImage() {
        return RhinoImageRegistry.getSharedImage("IMG_MAIN_TAB");
    }
}

