/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.StringJoiner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.WorkbenchActionBuilder;
import org.eclipse.ui.internal.ide.application.IDEWorkbenchAdvisor;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.tweaklets.TitlePathUpdater;
import org.eclipse.ui.internal.tweaklets.Tweaklets;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class IDEWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private IDEWorkbenchAdvisor wbAdvisor;
    private boolean editorsAndIntrosOpened = false;
    private IEditorPart lastActiveEditor = null;
    private IPerspectiveDescriptor lastPerspective = null;
    private IWorkbenchPage lastActivePage;
    private String lastEditorTitleTooltip = "";
    private IPropertyListener editorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && IDEWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                String newTitle = IDEWorkbenchWindowAdvisor.this.lastActiveEditor.getTitleToolTip();
                if (!IDEWorkbenchWindowAdvisor.this.lastEditorTitleTooltip.equals(newTitle)) {
                    IDEWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }
        }
    };
    private IAdaptable lastInput;
    private ActionFactory.IWorkbenchAction openPerspectiveAction;
    private IPropertyChangeListener propertyChangeListener;
    private TitlePathUpdater titlePathUpdater;

    public IDEWorkbenchWindowAdvisor(IDEWorkbenchAdvisor wbAdvisor, IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.wbAdvisor = wbAdvisor;
        this.titlePathUpdater = (TitlePathUpdater)Tweaklets.get((Tweaklets.TweakKey)TitlePathUpdater.KEY);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new WorkbenchActionBuilder(configurer);
    }

    private IWorkbench getWorkbench() {
        return this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
    }

    public boolean preWindowShellClose() {
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        return IDEWorkbenchWindowAdvisor.promptOnExit(this.getWindowConfigurer().getWindow().getShell());
    }

    static boolean promptOnExit(Shell parentShell) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        if (promptOnExit) {
            IWorkbenchWindow workbenchWindow;
            if (parentShell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                parentShell = workbenchWindow.getShell();
            }
            if (parentShell != null) {
                parentShell.setMinimized(false);
                parentShell.forceActive();
            }
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            String message = productName == null ? IDEWorkbenchMessages.PromptOnExitDialog_message0 : NLS.bind((String)IDEWorkbenchMessages.PromptOnExitDialog_message1, (Object)productName);
            LinkedHashMap<String, Integer> buttonLabelToIdMap = new LinkedHashMap<String, Integer>();
            buttonLabelToIdMap.put(IDEWorkbenchMessages.PromptOnExitDialog_button_label_exit, 0);
            buttonLabelToIdMap.put(IDialogConstants.CANCEL_LABEL, 1);
            MessageDialogWithToggle dlg = new MessageDialogWithToggle(parentShell, IDEWorkbenchMessages.PromptOnExitDialog_shellTitle, null, message, 5, buttonLabelToIdMap, 0, null, false);
            dlg.open();
            if (dlg.getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
                IDEWorkbenchPlugin.getDefault().savePluginPreferences();
            }
        }
        return true;
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter(configurer.getWindow()));
        this.hookTitleUpdateListeners(configurer);
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageClosed(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                IDEWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == IDEWorkbenchWindowAdvisor.this.lastActiveEditor && IDEWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle(true);
                }
            }

            public void partVisible(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == IDEWorkbenchWindowAdvisor.this.lastActiveEditor && IDEWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if ("WORKSPACE_NAME".equals(property) || "SHOW_LOCATION".equals(property) || "SHOW_LOCATION_NAME".equals(property) || "SHOW_PERSPECTIVE_IN_TITLE".equals(property) || "SHOW_PRODUCT_IN_TITLE".equals(property)) {
                    IDEWorkbenchWindowAdvisor.this.lastActivePage = null;
                    IDEWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }
        };
        IDEWorkbenchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private String computeTitle() {
        IProduct product;
        String workspaceLocation;
        IPerspectiveDescriptor persp;
        String workspaceName;
        StringJoiner sj = new StringJoiner(" - ");
        IPreferenceStore ps = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        IEditorPart activeEditor = null;
        if (currentPage != null) {
            activeEditor = this.lastActiveEditor;
        }
        if (ps.getBoolean("SHOW_LOCATION_NAME") && (workspaceName = ps.getString("WORKSPACE_NAME")) != null && workspaceName.length() > 0) {
            sj.add(workspaceName);
        }
        if (ps.getBoolean("SHOW_PERSPECTIVE_IN_TITLE") && (persp = currentPage.getPerspective()) != null) {
            sj.add(persp.getLabel());
        }
        if (currentPage != null && activeEditor != null) {
            sj.add(activeEditor.getTitleToolTip());
        }
        if ((workspaceLocation = this.wbAdvisor.getWorkspaceLocation()) != null) {
            sj.add(workspaceLocation);
        }
        if (ps.getBoolean("SHOW_PRODUCT_IN_TITLE") && (product = Platform.getProduct()) != null) {
            sj.add(product.getName());
        }
        return sj.toString();
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
        this.setTitlePath();
    }

    private void setTitlePath() {
        String titlePath = null;
        if (this.lastActiveEditor != null) {
            IEditorInput editorInput = this.lastActiveEditor.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                titlePath = this.computeTitlePath((IFileEditorInput)editorInput);
            } else if (editorInput instanceof FileStoreEditorInput) {
                titlePath = this.computeTitlePath((FileStoreEditorInput)editorInput);
            }
        }
        this.titlePathUpdater.updateTitlePath(this.getWindowConfigurer().getWindow().getShell(), titlePath);
    }

    private String computeTitlePath(FileStoreEditorInput editorInput) {
        return editorInput.getURI().getPath();
    }

    private String computeTitlePath(IFileEditorInput editorInput) {
        IFile file = editorInput.getFile();
        IPath location = file.getLocation();
        if (location != null) {
            return location.toFile().toString();
        }
        return null;
    }

    private void updateTitle(boolean editorHidden) {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IEditorPart activeEditor = null;
        IWorkbenchPage currentPage = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        IAdaptable input = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
            persp = currentPage.getPerspective();
            input = currentPage.getInput();
        }
        if (editorHidden) {
            activeEditor = null;
        }
        if (activeEditor == this.lastActiveEditor && currentPage == this.lastActivePage && persp == this.lastPerspective && input == this.lastInput) {
            return;
        }
        if (this.lastActiveEditor != null) {
            this.lastActiveEditor.removePropertyListener(this.editorPropertyListener);
        }
        if (window.isClosing()) {
            return;
        }
        this.lastActiveEditor = activeEditor;
        this.lastActivePage = currentPage;
        this.lastPerspective = persp;
        this.lastInput = input;
        if (activeEditor != null) {
            activeEditor.addPropertyListener(this.editorPropertyListener);
        }
        this.recomputeTitle();
    }

    public void postWindowRestore() throws WorkbenchException {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        int index = this.getWorkbench().getWorkbenchWindowCount() - 1;
        AboutInfo[] welcomePerspectiveInfos = this.wbAdvisor.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomePerspectiveInfos != null && index < welcomePerspectiveInfos.length) {
            IWorkbenchPage[] pages;
            IWorkbenchPage page = window.getActivePage();
            if (page == null && (pages = window.getPages()) != null && pages.length > 0) {
                page = pages[0];
            }
            String perspectiveId = welcomePerspectiveInfos[index].getWelcomePerspectiveId();
            if (page == null) {
                IAdaptable root = this.wbAdvisor.getDefaultPageInput();
                page = window.openPage(perspectiveId, root);
            } else {
                IPerspectiveRegistry reg = this.getWorkbench().getPerspectiveRegistry();
                IPerspectiveDescriptor desc = reg.findPerspectiveWithId(perspectiveId);
                if (desc != null) {
                    page.setPerspective(desc);
                }
            }
            window.setActivePage(page);
            page.openEditor((IEditorInput)new WelcomeEditorInput(welcomePerspectiveInfos[index]), WELCOME_EDITOR_ID, true);
        }
        this.cleanUpEditorArea();
    }

    public void openIntro() {
        if (this.editorsAndIntrosOpened) {
            return;
        }
        this.editorsAndIntrosOpened = true;
        if (this.wbAdvisor.hasIntro()) {
            super.openIntro();
        } else {
            this.openWelcomeEditors(this.getWindowConfigurer().getWindow());
            IDEWorkbenchPlugin.getDefault().savePluginPreferences();
        }
    }

    private void openWelcomeEditors(IWorkbenchWindow window) {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            IProduct product = Platform.getProduct();
            if (product == null) {
                return;
            }
            AboutInfo productInfo = new AboutInfo(product);
            URL url = productInfo.getWelcomePageURL();
            if (url == null) {
                return;
            }
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            this.openWelcomeEditor(window, new WelcomeEditorInput(productInfo), null);
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            for (AboutInfo info : this.wbAdvisor.getNewlyAddedBundleGroups().values()) {
                Bundle bundle;
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
                String pi = info.getBrandingBundleId();
                if (pi == null || (bundle = Platform.getBundle((String)pi)) == null) continue;
                try {
                    bundle.start(1);
                }
                catch (BundleException exception) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.ui.ide.application", "Failed to load feature", (Throwable)exception));
                }
            }
            int wCount = this.getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.getWorkbench().openWorkbenchWindow(perspectiveId, this.wbAdvisor.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log((String)"Error opening window with welcome perspective.", (IStatus)e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.wbAdvisor.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
        }
    }

    public Control createEmptyWindowContents(Composite parent) {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Display display = composite.getDisplay();
        Color bgCol = display.getSystemColor(34);
        composite.setBackground(bgCol);
        Label label = new Label(composite, 64);
        label.setForeground(display.getSystemColor(33));
        label.setBackground(bgCol);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        String msg = IDEWorkbenchMessages.IDEWorkbenchAdvisor_noPerspective;
        label.setText(msg);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.openPerspectiveAction = ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window);
        toolBarManager.add((IAction)this.openPerspectiveAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        toolBar.setBackground(bgCol);
        return composite;
    }

    public void dispose() {
        if (this.propertyChangeListener != null) {
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.openPerspectiveAction != null) {
            this.openPerspectiveAction.dispose();
            this.openPerspectiveAction = null;
        }
        super.dispose();
    }
}

