/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.Splitter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.AdaptableHierarchicalResourceList;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.HistoryTableProvider;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class RestoreFromRepositoryFileSelectionPage
extends CVSWizardPage {
    private TreeViewer fileTree;
    private CompareViewerPane fileSelectionPane;
    private CompareViewerPane revisionSelectionPane;
    private CheckboxTableViewer revisionsTable;
    private CompareViewerSwitchingPane fileContentPane;
    private HistoryTableProvider historyTableProvider;
    private AdaptableHierarchicalResourceList treeInput = new AdaptableHierarchicalResourceList((IContainer)ResourcesPlugin.getWorkspace().getRoot(), new IResource[0]);
    private IContainer folder;
    private IFile selectedFile;
    private ILogEntry selectedRevision;
    private Map<IFile, ILogEntry[]> entriesCache = new HashMap<IFile, ILogEntry[]>();
    private Map<IFile, Object> filesToRestore = new HashMap<IFile, Object>();
    private static final int WIZARD_WIDTH = 550;

    public RestoreFromRepositoryFileSelectionPage(String pageName, String title, ImageDescriptor titleImage, String description) {
        super(pageName, title, titleImage, description);
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.restore_from_repository_file_selection_page_context");
        Splitter vsplitter = new Splitter(composite, 512);
        GridData data = new GridData(1808);
        data.widthHint = 550;
        vsplitter.setLayoutData((Object)data);
        Splitter hsplitter = new Splitter((Composite)vsplitter, 256);
        this.fileSelectionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        data = new GridData(1808);
        this.fileSelectionPane.setLayoutData((Object)data);
        this.fileTree = this.createFileSelectionTree(this.fileSelectionPane);
        this.revisionSelectionPane = new CompareViewerPane((Composite)hsplitter, 0x800800);
        data = new GridData(1808);
        this.revisionSelectionPane.setLayoutData((Object)data);
        this.historyTableProvider = new HistoryTableProvider();
        this.revisionsTable = this.createRevisionSelectionTable(this.revisionSelectionPane, this.historyTableProvider);
        this.revisionSelectionPane.setText(CVSUIMessages.RestoreFromRepositoryFileSelectionPage_emptyRevisionPane);
        this.fileContentPane = new CompareViewerSwitchingPane((Composite)vsplitter, 0x800800){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                return CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, null);
            }
        };
        hsplitter.setWeights(new int[]{40, 60});
        this.initializeValues();
        this.updateWidgetEnablements();
        Dialog.applyDialogFont((Control)parent);
    }

    protected CheckboxTableViewer createRevisionSelectionTable(CompareViewerPane composite, HistoryTableProvider tableProvider) {
        CheckboxTableViewer table = tableProvider.createCheckBoxTable((Composite)composite);
        table.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] entries = RestoreFromRepositoryFileSelectionPage.this.getSelectedEntries();
                if (entries != null) {
                    return entries;
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        table.setInput((Object)this);
        table.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail == 32) {
                    return;
                }
                RestoreFromRepositoryFileSelectionPage.this.handleRevisionSelection(e.item);
            }
        });
        table.addCheckStateListener(event -> this.handleRevisionChecked(event));
        composite.setContent(table.getControl());
        return table;
    }

    protected TreeViewer createFileSelectionTree(CompareViewerPane composite) {
        TreeViewer tree = new TreeViewer((Composite)composite, 2816);
        tree.setUseHashlookup(true);
        tree.setContentProvider((IContentProvider)this.treeInput.getTreeContentProvider());
        tree.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(){

            protected String decorateText(String input, Object element) {
                String text;
                if (element instanceof IFolder && element.equals(RestoreFromRepositoryFileSelectionPage.this.folder)) {
                    text = super.decorateText(RestoreFromRepositoryFileSelectionPage.this.folder.getProjectRelativePath().toString(), element);
                } else {
                    ILogEntry entry = (ILogEntry)RestoreFromRepositoryFileSelectionPage.this.filesToRestore.get(element);
                    text = super.decorateText(input, element);
                    if (entry != null) {
                        text = NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_fileToRestore, (Object[])new String[]{text, entry.getRevision()});
                    }
                }
                return text;
            }
        }, CVSUIPlugin.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator()));
        tree.setComparator((ViewerComparator)new ResourceComparator(1));
        tree.setInput((Object)this.treeInput);
        GridData data = new GridData(1808);
        tree.getTree().setLayoutData((Object)data);
        tree.addPostSelectionChangedListener(event -> this.handleFileSelection(event));
        composite.setContent(tree.getControl());
        return tree;
    }

    private void updateWidgetEnablements() {
        if (this.filesToRestore.isEmpty()) {
            this.setPageComplete(false);
            this.setErrorMessage(null);
            return;
        }
        for (IFile file : this.filesToRestore.keySet()) {
            if (file.exists()) {
                this.setPageComplete(false);
                this.setErrorMessage(NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_fileExists, (Object[])new String[]{file.getName()}));
                return;
            }
            ILogEntry entry = (ILogEntry)this.filesToRestore.get(file);
            if (!entry.isDeletion()) continue;
            this.setPageComplete(false);
            this.setErrorMessage(NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_revisionIsDeletion, (Object[])new String[]{entry.getRevision(), file.getName()}));
            return;
        }
        this.setPageComplete(true);
        this.setErrorMessage(null);
    }

    private void initializeValues() {
        this.refresh();
    }

    public void setInput(IContainer folder, ICVSFile[] files) {
        if (folder.equals((Object)this.folder)) {
            return;
        }
        this.folder = folder;
        this.setTreeInput(folder, files);
        this.initializeValues();
        this.updateWidgetEnablements();
    }

    private void setTreeInput(IContainer folder, ICVSFile[] cvsFiles) {
        this.reset();
        IResource[] files = new IResource[cvsFiles.length];
        int i = 0;
        while (i < cvsFiles.length) {
            files[i] = cvsFiles[i].getIResource();
            ++i;
        }
        this.treeInput.setResources(files);
        this.treeInput.setRoot(folder.getParent());
        this.refresh();
    }

    private void reset() {
        this.selectedFile = null;
        this.selectedRevision = null;
        this.treeInput.setResources(null);
        this.filesToRestore = new HashMap<IFile, Object>();
        if (this.fileContentPane != null && !this.fileContentPane.isDisposed()) {
            this.fileContentPane.setInput(null);
        }
        this.updateWidgetEnablements();
    }

    private void refresh() {
        if (this.folder == null) {
            return;
        }
        if (this.fileSelectionPane != null && !this.fileSelectionPane.isDisposed()) {
            this.fileSelectionPane.setText(NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_fileSelectionPaneTitle, (Object[])new String[]{this.folder.getProject().getName()}));
            this.fileSelectionPane.setImage(CompareUI.getImage((IAdaptable)this.folder.getProject()));
        }
        if (this.revisionSelectionPane != null && !this.revisionSelectionPane.isDisposed() && this.selectedFile == null) {
            this.revisionSelectionPane.setText(CVSUIMessages.RestoreFromRepositoryFileSelectionPage_emptyRevisionPane);
            this.revisionSelectionPane.setImage(null);
        }
        if (this.fileContentPane != null && !this.fileContentPane.isDisposed()) {
            this.fileContentPane.setInput(null);
        }
        if (this.fileTree != null) {
            this.fileTree.setExpandedState((Object)this.folder, true);
            this.fileTree.refresh();
        }
        if (this.revisionsTable != null) {
            this.revisionsTable.refresh();
        }
    }

    private void setLogEntryTableInput(ILogEntry[] entries) {
        this.selectedRevision = null;
        this.revisionsTable.refresh();
        ILogEntry selectedEntry = (ILogEntry)this.filesToRestore.get(this.selectedFile);
        if (selectedEntry != null) {
            this.revisionsTable.setChecked((Object)selectedEntry, true);
        }
        ILogEntry[] iLogEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            ILogEntry entry = iLogEntryArray[n2];
            if (entry.isDeletion()) {
                this.revisionsTable.setGrayed((Object)entry, true);
            }
            ++n2;
        }
        this.revisionSelectionPane.setText(NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_revisionSelectionPaneTitle, (Object[])new String[]{this.selectedFile.getName()}));
        this.revisionSelectionPane.setImage(CompareUI.getImage((IAdaptable)this.selectedFile));
        this.fileContentPane.setInput(null);
    }

    private void handleFileSelection(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (selection == null || selection.isEmpty()) {
            this.clearSelection();
        } else if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            IResource resource = (IResource)structuredSelection.getFirstElement();
            if (resource instanceof IFile) {
                this.handleFileSelection((IFile)resource);
            } else {
                this.clearSelection();
            }
        }
    }

    private void handleFileSelection(IFile file) {
        if (this.selectedFile == file) {
            return;
        }
        this.selectedFile = file;
        if (this.entriesCache.get(file) == null) {
            try {
                ICVSFolder parent = CVSWorkspaceRoot.getCVSFolderFor((IContainer)file.getParent());
                FolderSyncInfo info = parent.getFolderSyncInfo();
                ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
                ICVSRemoteFile remoteFile = location.getRemoteFile(new Path(null, info.getRepository()).append(file.getName()).toString(), CVSTag.DEFAULT);
                this.getContainer().run(true, true, monitor -> {
                    try {
                        ILogEntry[] entries = remoteFile.getLogEntries(monitor);
                        this.entriesCache.put(this.selectedFile, entries);
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                });
            }
            catch (CVSException e) {
                this.setErrorMessage(CVSUIPlugin.openError(this.getShell(), null, null, e, 1).getMessage());
                return;
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(CVSUIPlugin.openError(this.getShell(), null, null, e, 1).getMessage());
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
        this.setLogEntryTableInput(this.getSelectedEntries());
    }

    private ILogEntry[] getSelectedEntries() {
        return this.entriesCache.get(this.selectedFile);
    }

    private IStorage getStorageFromLogEntry(ILogEntry logEntry) {
        IStorage[] s = new IStorage[1];
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    ICVSRemoteFile remoteFile = logEntry.getRemoteFile();
                    iStorageArray[0] = ((IResourceVariant)remoteFile).getStorage(monitor);
                }
                catch (TeamException e) {
                    throw new InvocationTargetException(e);
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(CVSUIPlugin.openError(this.getShell(), null, null, e, 1).getMessage());
            return null;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return s[0];
    }

    private void handleRevisionChecked(CheckStateChangedEvent event) {
        if (event.getChecked()) {
            this.revisionsTable.setCheckedElements(new Object[]{event.getElement()});
            this.filesToRestore.put(this.selectedFile, event.getElement());
        }
        if (this.revisionsTable.getCheckedElements().length == 0) {
            this.filesToRestore.remove(this.selectedFile);
        }
        this.fileTree.refresh();
        this.updateWidgetEnablements();
    }

    private void handleRevisionSelection(Widget w) {
        if (this.fileContentPane != null && !this.fileContentPane.isDisposed()) {
            Object o = w.getData();
            if (o instanceof ILogEntry) {
                ILogEntry selected = (ILogEntry)o;
                if (this.selectedRevision == selected) {
                    return;
                }
                this.selectedRevision = selected;
                if (selected.isDeletion()) {
                    this.fileContentPane.setInput(null);
                } else {
                    this.fileContentPane.setInput((Object)new HistoryInput(this.selectedFile, selected));
                    this.fileContentPane.setText(this.getEditionLabel(this.selectedFile, selected));
                    this.fileContentPane.setImage(CompareUI.getImage((IAdaptable)this.selectedFile));
                }
            } else {
                this.fileContentPane.setInput(null);
            }
        }
    }

    private String getEditionLabel(IFile selectedFile, ILogEntry selected) {
        return NLS.bind((String)CVSUIMessages.RestoreFromRepositoryFileSelectionPage_fileContentPaneTitle, (Object[])new Object[]{selectedFile.getName(), selected.getRevision(), selectedFile.getFullPath().makeRelative().removeLastSegments(1).toString()});
    }

    public boolean restoreSelectedFiles() {
        try {
            this.getContainer().run(true, true, monitor -> {
                try {
                    try {
                        monitor.beginTask(null, 100 * this.filesToRestore.size());
                        for (IFile file : this.filesToRestore.keySet()) {
                            ILogEntry entry = (ILogEntry)this.filesToRestore.get(file);
                            this.ensureParentExists((IResource)file);
                            file.create(entry.getRemoteFile().getContents(Policy.subMonitorFor(monitor, 50)), false, Policy.subMonitorFor(monitor, 50));
                        }
                    }
                    catch (TeamException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    catch (CoreException e2) {
                        throw new InvocationTargetException(e2);
                    }
                }
                finally {
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            this.setErrorMessage(CVSUIPlugin.openError(this.getShell(), null, null, e, 1).getMessage());
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void ensureParentExists(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (!parent.exists() && parent.getType() == 2) {
            this.ensureParentExists((IResource)parent);
            ((IFolder)parent).create(false, true, null);
        }
    }

    private void clearSelection() {
        this.selectedFile = null;
        this.selectedRevision = null;
        this.refresh();
    }

    class HistoryInput
    implements ITypedElement,
    IEncodedStreamContentAccessor,
    IModificationDate {
        IFile file;
        ILogEntry logEntry;

        HistoryInput(IFile file, ILogEntry logEntry) {
            this.file = file;
            this.logEntry = logEntry;
        }

        public InputStream getContents() throws CoreException {
            IStorage s = RestoreFromRepositoryFileSelectionPage.this.getStorageFromLogEntry(this.logEntry);
            if (s == null) {
                return null;
            }
            return new BufferedInputStream(s.getContents());
        }

        public String getName() {
            return this.file.getName();
        }

        public String getType() {
            return this.file.getFileExtension();
        }

        public Image getImage() {
            return CompareUI.getImage((IAdaptable)this.file);
        }

        public long getModificationDate() {
            return this.logEntry.getDate().getTime();
        }

        public String getCharset() throws CoreException {
            IStorage s = RestoreFromRepositoryFileSelectionPage.this.getStorageFromLogEntry(this.logEntry);
            if (s instanceof IEncodedStorage) {
                return ((IEncodedStorage)s).getCharset();
            }
            return null;
        }
    }
}

