/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceAction;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkbenchPage;

public class ShowResourceInHistoryAction
extends WorkspaceAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(monitor -> {
            IResource[] resources = this.getSelectedResources();
            if (resources.length != 1) {
                return;
            }
            TeamUI.showHistoryFor((IWorkbenchPage)TeamUIPlugin.getActivePage(), (Object)resources[0], null);
        }, false, 2);
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.ShowHistoryAction_showHistory;
    }

    @Override
    protected boolean isEnabledForMultipleResources() {
        return false;
    }

    @Override
    protected boolean isEnabledForAddedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForNonExistantResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        return !cvsResource.isFolder() && super.isEnabledForCVSResource(cvsResource);
    }

    @Override
    public String getId() {
        return "org.eclipse.team.cvs.ui.showHistory";
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForIgnoredResources() {
        return true;
    }
}

