/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.business.internal.refresh;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.table.metamodel.table.provider.Messages;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.widgets.Shell;

public final class TableRefresherHelper {
    private TableRefresherHelper() {
    }

    public static void refreshEditor(final AbstractDTableEditor tableEditor, IProgressMonitor theMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)theMonitor, (int)1);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                TransactionalEditingDomain domain = tableEditor.getEditingDomain();
                domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{tableEditor.getTableModel()}));
            }
        };
        Shell activeShell = tableEditor.getSite().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            try {
                tableEditor.enablePropertiesUpdate(false);
                RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)tableEditor.getTableModel());
                monitorDialog.run(true, false, op);
                subMonitor.split(1);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)Messages.Refresh_error, (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error(Messages.Refresh_errorDuringRefresh, (Throwable)e);
                tableEditor.enablePropertiesUpdate(true);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.Refresh_cancelled, (String)e.getMessage());
                tableEditor.enablePropertiesUpdate(true);
            }
        }
        finally {
            tableEditor.enablePropertiesUpdate(true);
        }
    }
}

