/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.palette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.ui.business.internal.helper.CreateConnectionRequestHelper;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.command.DoNothingCommand;
import org.eclipse.sirius.diagram.ui.tools.api.command.GMFCommandWrapper;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.ConnectionCreationTool;
import org.eclipse.sirius.diagram.ui.tools.internal.palette.CreationTool;
import org.eclipse.sirius.diagram.ui.tools.internal.part.SiriusDiagramGraphicalViewer;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GenericConnectionCreationTool
extends ConnectionCreationTool {
    private PaletteRoot paletteRoot;
    private List<ConnectionCreationToolEntry> connectionToolEntries;
    private Map<ConnectionCreationToolEntry, CreateConnectionRequest> startToolToRequest;
    private Map<ConnectionCreationToolEntry, CreateConnectionRequest> endToolToRequest;
    private boolean targetHasChanged;

    public void activate() {
        super.activate();
        if (this.paletteRoot == null) {
            this.paletteRoot = this.getDomain().getPaletteViewer().getPaletteRoot();
        }
        this.connectionToolEntries = new ArrayList<ConnectionCreationToolEntry>();
        for (Object container : this.paletteRoot.getChildren()) {
            PaletteContainer paletteContainer = (PaletteContainer)container;
            this.computeToolEntriesFromContainer(paletteContainer);
        }
        this.startToolToRequest = null;
        this.endToolToRequest = null;
        this.setFactory(new GenericConnectionRequestCreationFactory(null));
    }

    protected boolean updateTargetUnderMouse() {
        this.targetHasChanged = super.updateTargetUnderMouse();
        return this.targetHasChanged;
    }

    private void computeToolEntriesFromContainer(PaletteContainer paletteContainer) {
        for (Object entry : paletteContainer.getChildren()) {
            if (entry instanceof ConnectionCreationToolEntry) {
                this.connectionToolEntries.add((ConnectionCreationToolEntry)entry);
                continue;
            }
            if (!(entry instanceof PaletteContainer)) continue;
            this.computeToolEntriesFromContainer((PaletteContainer)entry);
        }
    }

    protected org.eclipse.gef.commands.Command getCommand() {
        UnexecutableCommand commandToReturn = UnexecutableCommand.INSTANCE;
        CreateConnectionRequest request = (CreateConnectionRequest)this.getTargetRequest();
        if ("connection start".equals(request.getType())) {
            commandToReturn = this.handleConnectionStart(request);
        } else if ("connection end".equals(request.getType())) {
            commandToReturn = this.handleConnectionEnd();
        }
        return commandToReturn;
    }

    private org.eclipse.gef.commands.Command handleConnectionStart(CreateConnectionRequest request) {
        EditPart editPart = this.getTargetEditPart();
        if (this.targetHasChanged) {
            this.startToolToRequest = new HashMap<ConnectionCreationToolEntry, CreateConnectionRequest>();
            for (ConnectionCreationToolEntry toolEntry : this.connectionToolEntries) {
                CreateConnectionRequest newRequest;
                org.eclipse.gef.commands.Command currentCommand;
                Optional<EdgeCreationDescription> optional = this.getCreationToolDescription(EdgeCreationDescription.class, (CreationToolEntry)toolEntry);
                if (!optional.isPresent() || (currentCommand = editPart.getCommand((Request)(newRequest = this.createNewConnectionRequest(request, optional.get())))) == null || !currentCommand.canExecute()) continue;
                this.startToolToRequest.put(toolEntry, newRequest);
            }
        } else {
            this.updateRequestLocation(this.startToolToRequest.values(), request, editPart, true);
        }
        return this.startToolToRequest.isEmpty() ? UnexecutableCommand.INSTANCE : DoNothingCommand.INSTANCE;
    }

    private void updateRequestLocation(Collection<CreateConnectionRequest> requests, CreateConnectionRequest originalRequest, EditPart editPart, boolean start) {
        requests.stream().forEach(current -> {
            current.setLocation(originalRequest.getLocation().getCopy());
            if (start) {
                CreateConnectionRequestHelper.computeConnectionStartExtendedData(current, (INodeEditPart)editPart);
            }
        });
    }

    private org.eclipse.gef.commands.Command handleConnectionEnd() {
        EditPart editPart = this.getTargetEditPart();
        if (this.endToolToRequest == null || this.targetHasChanged) {
            this.endToolToRequest = new HashMap<ConnectionCreationToolEntry, CreateConnectionRequest>();
            for (ConnectionCreationToolEntry toolEntry : this.startToolToRequest.keySet()) {
                Optional<EdgeCreationDescription> optional = this.getCreationToolDescription(EdgeCreationDescription.class, (CreationToolEntry)toolEntry);
                if (!optional.isPresent()) continue;
                CreateConnectionRequest request = this.startToolToRequest.get(toolEntry);
                org.eclipse.gef.commands.Command currentCommand = null;
                if (request != null) {
                    this.updateRequest(request);
                    currentCommand = editPart.getCommand((Request)request);
                }
                if (currentCommand == null || !currentCommand.canExecute()) continue;
                this.endToolToRequest.put(toolEntry, request);
            }
        } else {
            this.updateRequestLocation(this.endToolToRequest.values(), (CreateConnectionRequest)this.getTargetRequest(), editPart, false);
        }
        return this.endToolToRequest.isEmpty() ? UnexecutableCommand.INSTANCE : this.createCompleteCommand();
    }

    private org.eclipse.gef.commands.Command createCompleteCommand() {
        EditPartViewer editPartViewer = this.getCurrentViewer();
        EdgeTarget source = this.getEdgeTargetFromEditPart(this.getTargetEditPart());
        if (editPartViewer instanceof SiriusDiagramGraphicalViewer) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)source);
            return new ICommandProxy((ICommand)new GMFCommandWrapper(editingDomain, (Command)new GenericEdgeCreationToolCommand(editingDomain, editPartViewer.getControl(), this.endToolToRequest)));
        }
        return UnexecutableCommand.INSTANCE;
    }

    private EdgeTarget getEdgeTargetFromEditPart(EditPart editPart) {
        DDiagramElement element;
        if (editPart instanceof IDiagramElementEditPart && (element = ((IDiagramElementEditPart)editPart).resolveDiagramElement()) instanceof EdgeTarget) {
            return (EdgeTarget)element;
        }
        return null;
    }

    private <E extends MappingBasedToolDescription> Optional<E> getCreationToolDescription(Class<E> type, CreationToolEntry entry) {
        Object toolProperty = entry.getToolProperty(CreationTool.PROPERTY_CREATION_FACTORY);
        Optional<MappingBasedToolDescription> edgeCreationDescriptionOptional = Optional.ofNullable(toolProperty).filter(CreationFactory.class::isInstance).map(factory -> ((CreationFactory)toolProperty).getNewObject()).filter(type::isInstance).map(type::cast);
        return edgeCreationDescriptionOptional;
    }

    private void updateRequest(CreateConnectionRequest requestToUpdate) {
        requestToUpdate.setType((Object)this.getCommandName());
        requestToUpdate.setLocation(((CreateConnectionRequest)this.getTargetRequest()).getLocation());
        requestToUpdate.setSourceEditPart(((CreateConnectionRequest)this.getTargetRequest()).getSourceEditPart());
        requestToUpdate.setTargetEditPart(((CreateConnectionRequest)this.getTargetRequest()).getTargetEditPart());
    }

    private CreateConnectionRequest createNewConnectionRequest(CreateConnectionRequest request, EdgeCreationDescription description) {
        CreateConnectionRequest connectionRequest = new CreateConnectionRequest();
        connectionRequest.setLocation(request.getLocation().getCopy());
        connectionRequest.setSourceEditPart(request.getSourceEditPart());
        connectionRequest.setTargetEditPart(request.getTargetEditPart());
        connectionRequest.setStartCommand(request.getStartCommand());
        connectionRequest.setType(request.getType());
        connectionRequest.setSnapToEnabled(request.isSnapToEnabled());
        connectionRequest.setFactory((CreationFactory)new GenericConnectionRequestCreationFactory((AbstractToolDescription)description));
        HashMap extendedData = new HashMap(request.getExtendedData());
        connectionRequest.setExtendedData(extendedData);
        return connectionRequest;
    }

    public void deactivate() {
        this.paletteRoot = null;
        this.connectionToolEntries.clear();
        this.startToolToRequest = null;
        this.endToolToRequest = null;
        super.deactivate();
    }

    private static class GenericConnectionRequestCreationFactory
    implements CreationFactory {
        private AbstractToolDescription abstractToolDescription;

        GenericConnectionRequestCreationFactory(AbstractToolDescription abstractToolDescription) {
            this.abstractToolDescription = abstractToolDescription;
        }

        public Object getNewObject() {
            return this.abstractToolDescription;
        }

        public Object getObjectType() {
            return this.abstractToolDescription.getClass();
        }
    }

    private static class GenericEdgeCreationToolCommand
    extends RecordingCommand {
        private Control control;
        private Map<ConnectionCreationToolEntry, CreateConnectionRequest> toolToRequest;

        GenericEdgeCreationToolCommand(TransactionalEditingDomain domain, Control control, Map<ConnectionCreationToolEntry, CreateConnectionRequest> toolToRequest) {
            super(domain, Messages.GenericConnectionCreationTool_label);
            this.control = control;
            this.toolToRequest = toolToRequest;
        }

        protected void doExecute() {
            if (this.toolToRequest.size() == 1) {
                this.toolToRequest.values().stream().map(r -> r.getTargetEditPart().getCommand((Request)r)).findFirst().ifPresent(cmd -> cmd.execute());
            } else {
                Menu menu = new Menu(this.control);
                for (ConnectionCreationToolEntry entry : this.toolToRequest.keySet()) {
                    CreateConnectionRequest request = this.toolToRequest.get(entry);
                    org.eclipse.gef.commands.Command currentCommand = request.getTargetEditPart().getCommand((Request)request);
                    this.createMenuItem(entry, menu, currentCommand);
                }
                menu.setVisible(true);
                Display display = menu.getDisplay();
                while (!menu.isDisposed() && menu.isVisible()) {
                    if (display.readAndDispatch()) continue;
                    display.sleep();
                }
                while (display.readAndDispatch()) {
                }
                if (!menu.isDisposed()) {
                    menu.dispose();
                }
            }
        }

        private void createMenuItem(ConnectionCreationToolEntry entry, Menu menu, final org.eclipse.gef.commands.Command command) {
            MenuItem item = new MenuItem(menu, 64);
            ImageDescriptor descriptor = entry.getSmallIcon();
            if (descriptor != null) {
                item.setImage(descriptor.createImage());
            }
            item.setText(entry.getLabel());
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    super.widgetSelected(e);
                    command.execute();
                }
            });
        }
    }
}

