/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractFrame;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Operand;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.ordering.CompoundEventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.sequence.ui.Messages;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.part.ExecutionEditPart;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.edit.validator.PositionsChecker;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.FinalParentHelper;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class AbstractNodeEventResizeSelectionValidator {
    private static final String EXECUTION_RESIZE_VALIDATOR = "org.eclipse.sirius.sequence.resize.execution.validator";
    protected Range expansionZone;
    protected ISequenceEvent finalParent;
    protected Map<AbstractNodeEvent, Location> moveDeltas = new HashMap<AbstractNodeEvent, Location>();
    private boolean valid;
    private AbstractNodeEvent host;
    private ChangeBoundsRequest request;
    private boolean initialized;
    private Collection<Integer> invalidPositions = new ArrayList<Integer>();
    private RequestQuery requestQuery;

    protected AbstractNodeEventResizeSelectionValidator(AbstractNodeEvent host, ChangeBoundsRequest request) {
        this.host = host;
        this.requestQuery = new RequestQuery((Request)request);
        Preconditions.checkArgument((boolean)this.requestQuery.isResize());
        this.request = request;
    }

    public final boolean isValid() {
        this.validate();
        return this.valid;
    }

    public final void validate() {
        if (!this.initialized) {
            this.doValidation();
            this.initialized = true;
        }
    }

    private void doValidation() {
        Preconditions.checkNotNull((Object)this.host, (Object)Messages.AbstractNodeEventResizeSelectionValidator_nullExecution);
        FinalParentHelper finalParentHelper = new FinalParentHelper(this.host, this.requestQuery);
        finalParentHelper.computeFinalParent();
        this.expansionZone = finalParentHelper.getRequiredExpansion();
        this.finalParent = finalParentHelper.getFinalParent();
        if (this.finalParent == null && this.requestQuery.isResizeFromBottom() && this.expansionZone != null && this.expansionZone.width() != 0) {
            this.finalParent = this.host.getParentEvent();
        }
        this.valid = this.validateNewBoundsForAllTargets() && this.finalParent != null;
        this.valid = this.valid && this.checkGlobalPositions();
    }

    protected boolean validateNewBoundsForAllTargets() {
        return Iterables.all((Iterable)Iterables.filter((Iterable)this.request.getEditParts(), ExecutionEditPart.class), (Predicate)new Predicate<ExecutionEditPart>(){

            public boolean apply(ExecutionEditPart input) {
                return AbstractNodeEventResizeSelectionValidator.this.validateNewBounds(input);
            }
        });
    }

    private boolean validateNewBounds(ExecutionEditPart self) {
        boolean result;
        boolean newBoundsFails;
        Rectangle bounds = self.getFigure().getBounds().getCopy();
        Rectangle newBounds = this.requestQuery.getFinalBounds(self);
        ISequenceEvent selfEvent = self.getISequenceEvent();
        ISequenceEvent parent = selfEvent.getParentEvent();
        boolean bl = newBoundsFails = newBounds.width <= 0 && bounds.width != 0 || newBounds.height <= 0;
        if (newBoundsFails || parent == null) {
            result = false;
        } else {
            boolean isMove = this.requestQuery.isMove();
            boolean okForChildren = isMove || RangeHelper.verticalRange((Rectangle)newBounds).includes(self.getISequenceEvent().getOccupiedRange());
            boolean okForParent = ((Lifeline)((AbstractNodeEvent)self.getISequenceEvent()).getLifeline().get()).getValidSubEventsRange().includes(RangeHelper.verticalRange((Rectangle)newBounds));
            if (this.requestQuery.isResize()) {
                if (parent instanceof Operand) {
                    okForParent = this.validateNewBounds(self, newBounds, (Operand)parent);
                } else if (!parent.getVerticalRange().includes(RangeHelper.verticalRange((Rectangle)newBounds))) {
                    okForParent = false;
                }
            }
            boolean okForMessageEnds = this.expansionZone != null || this.validateMessageEndsConsistency(self, bounds, newBounds);
            result = okForChildren && okForParent && okForMessageEnds;
        }
        return result;
    }

    private boolean validateNewBounds(ExecutionEditPart self, Rectangle newBounds, Operand parent) {
        boolean okForParent = false;
        if (this.requestQuery.isResizeFromBottom()) {
            if (parent.getValidSubEventsRange().getLowerBound() <= RangeHelper.verticalRange((Rectangle)newBounds).getLowerBound()) {
                okForParent = true;
                if (parent.getValidSubEventsRange().getUpperBound() < RangeHelper.verticalRange((Rectangle)newBounds).getUpperBound()) {
                    this.expansionZone = new Range(parent.getValidSubEventsRange().getUpperBound(), RangeHelper.verticalRange((Rectangle)newBounds).getUpperBound());
                }
            }
        } else if (this.requestQuery.isResizeFromTop()) {
            if (parent.getVerticalRange().getLowerBound() != RangeHelper.verticalRange((Rectangle)newBounds).getLowerBound()) {
                okForParent = true;
            }
        } else if (parent.getValidSubEventsRange().includes(RangeHelper.verticalRange((Rectangle)newBounds))) {
            okForParent = true;
        }
        return okForParent;
    }

    private boolean validateMessageEndsConsistency(ExecutionEditPart self, Rectangle bounds, Rectangle newBounds) {
        boolean result = true;
        AbstractNodeEvent abstractNodeEvent = (AbstractNodeEvent)self.getISequenceEvent();
        ArrayList delimitingMessages = Lists.newArrayList((Iterable)Iterables.filter((Iterable)EventEndHelper.getCompoundEvents((ISequenceEvent)self.getISequenceEvent()), Message.class));
        if (delimitingMessages.size() == 2) {
            ISequenceEvent finishMessageRemote;
            ISequenceEvent startMessageRemote;
            Message callMessage = (Message)delimitingMessages.get(0);
            Message returnMessage = (Message)delimitingMessages.get(1);
            Range oldRange = RangeHelper.verticalRange((Rectangle)bounds);
            Range newRange = RangeHelper.verticalRange((Rectangle)newBounds);
            int deltaYStart = newRange.getLowerBound() - oldRange.getLowerBound();
            int deltaYFinish = newRange.getUpperBound() - oldRange.getUpperBound();
            int deltaHStart = 0;
            int deltaHFinish = 0;
            if (this.requestQuery.isDirectedByMessage()) {
                if (this.requestQuery.isResizeFromTop() && callMessage.isReflective()) {
                    deltaHStart = deltaYStart;
                    deltaYStart = 0;
                }
                if (this.requestQuery.isResizeFromBottom() && returnMessage.isReflective()) {
                    deltaHFinish = -deltaYFinish;
                }
            }
            boolean bl = result = (startMessageRemote = FinalParentHelper.getFinalRemoteParent(abstractNodeEvent, (Message)delimitingMessages.get(0), deltaYStart, deltaHStart)) == (finishMessageRemote = FinalParentHelper.getFinalRemoteParent(abstractNodeEvent, (Message)delimitingMessages.get(1), deltaYFinish, deltaHFinish));
            if (!result && this.requestQuery.isResizeFromBottom() && finishMessageRemote != null) {
                Range verticalRange = finishMessageRemote.getVerticalRange();
                if (newRange.getLowerBound() < verticalRange.getLowerBound()) {
                    Range errorRange = new Range(verticalRange.getLowerBound() - 1, newRange.getUpperBound());
                    this.expansionZone = this.expansionZone == null ? errorRange : errorRange.union(this.expansionZone);
                    result = true;
                }
            }
            result = result && this.respectLowRangeMarginOfParent(startMessageRemote, callMessage, newRange) && this.respectUpperRangeMarginOfParent(startMessageRemote, returnMessage, newRange);
        } else if (delimitingMessages.size() == 1) {
            ISequenceEvent delimitingMessageRemote;
            ISequenceEvent prevMessageRemote;
            List ends = EventEndHelper.findEndsFromSemanticOrdering((ISequenceEvent)self.getISequenceEvent());
            SingleEventEnd delimitedSee = this.getDelimitedSingleEventEnd(self, ends);
            Range oldRange = RangeHelper.verticalRange((Rectangle)bounds);
            Range newRange = RangeHelper.verticalRange((Rectangle)newBounds);
            int deltaYStart = newRange.getLowerBound() - oldRange.getLowerBound();
            int deltaYFinish = newRange.getUpperBound() - oldRange.getUpperBound();
            int delimitedDeltaY = 0;
            int delimitedDeltaH = 0;
            if (delimitedSee != null) {
                int n = delimitedDeltaY = delimitedSee.isStart() ? deltaYStart : deltaYFinish;
                if (this.requestQuery.isDirectedByMessage()) {
                    Message msg = (Message)delimitingMessages.get(0);
                    if (delimitedSee.isStart() && this.requestQuery.isResizeFromTop() && msg.isReflective()) {
                        delimitedDeltaH = delimitedDeltaY;
                        delimitedDeltaY = 0;
                    }
                    if (!delimitedSee.isStart() && this.requestQuery.isResizeFromBottom() && msg.isReflective()) {
                        delimitedDeltaH = -delimitedDeltaY;
                    }
                }
            }
            result = (prevMessageRemote = FinalParentHelper.getFinalRemoteParent(abstractNodeEvent, (Message)delimitingMessages.get(0), 0, 0)) == (delimitingMessageRemote = FinalParentHelper.getFinalRemoteParent(abstractNodeEvent, (Message)delimitingMessages.get(0), delimitedDeltaY, delimitedDeltaH));
            Message callMessage = (Message)delimitingMessages.get(0);
            result = result && this.respectLowRangeMarginOfParent(prevMessageRemote, callMessage, newRange);
        }
        return result;
    }

    private boolean respectUpperRangeMarginOfParent(ISequenceEvent parentSequenceEvent, Message returnMessage, Range newRange) {
        boolean upperRangeMarginOK = true;
        if (parentSequenceEvent != null) {
            int upperRangeMargin;
            Range remoteParentRange = parentSequenceEvent.getVerticalRange();
            Range finishMessageRange = returnMessage.getVerticalRange();
            if (this.requestQuery.isDirectedByMessage() && this.requestQuery.isResizeFromBottom() && returnMessage.isReflective()) {
                finishMessageRange = new Range(finishMessageRange.getLowerBound() + this.requestQuery.getLogicalDelta().height, finishMessageRange.getUpperBound());
            }
            upperRangeMarginOK = (upperRangeMargin = Math.abs(remoteParentRange.getUpperBound() - (newRange.getUpperBound() + finishMessageRange.width()))) >= 5;
        }
        return upperRangeMarginOK;
    }

    private boolean respectLowRangeMarginOfParent(ISequenceEvent parentSequenceEvent, Message callMessage, Range newRange) {
        boolean lowerRangeMarginOK = true;
        if (parentSequenceEvent != null) {
            Range remoteParentRange = parentSequenceEvent.getVerticalRange();
            Range startMessageRange = callMessage.getVerticalRange();
            int lowerRangeMargin = Math.abs(newRange.getLowerBound() - startMessageRange.width() - remoteParentRange.getLowerBound());
            lowerRangeMarginOK = lowerRangeMargin >= 5;
        }
        return lowerRangeMarginOK;
    }

    private SingleEventEnd getDelimitedSingleEventEnd(ExecutionEditPart self, List<EventEnd> ends) {
        Iterable thisDelimitedEnds = Iterables.filter(ends, CompoundEventEnd.class);
        if (!Iterables.isEmpty((Iterable)thisDelimitedEnds)) {
            return EventEndHelper.getSingleEventEnd((EventEnd)((EventEnd)thisDelimitedEnds.iterator().next()), (EObject)self.resolveTargetSemanticElement());
        }
        return null;
    }

    public Range getExpansionZone() {
        return this.expansionZone;
    }

    public void setExpansionZone(Range expansionZone) {
        this.expansionZone = expansionZone;
    }

    public ISequenceEvent getFinalHierarchicalParent() {
        return this.getReconnectionFinalParent(this.finalParent);
    }

    private ISequenceEvent getReconnectionFinalParent(ISequenceEvent ise) {
        if (ise instanceof Operand) {
            return this.getReconnectionFinalParent((ISequenceEvent)((Operand)ise).getCombinedFragment());
        }
        ISequenceEvent reconnectionParent = ise;
        if (ise instanceof AbstractFrame) {
            AbstractFrame frame = (AbstractFrame)ise;
            Collection computeParentEvents = frame.computeParentEvents(Collections.singletonList((Lifeline)this.host.getLifeline().get()));
            ISequenceEvent iSequenceEvent = (ISequenceEvent)Iterables.get((Iterable)computeParentEvents, (int)0);
            reconnectionParent = iSequenceEvent instanceof Lifeline || iSequenceEvent instanceof AbstractNodeEvent ? iSequenceEvent : this.getReconnectionFinalParent(iSequenceEvent);
        }
        return reconnectionParent;
    }

    public void setFinalParent(ISequenceEvent finalParent) {
        this.finalParent = finalParent;
    }

    public static AbstractNodeEventResizeSelectionValidator getOrCreateValidator(ChangeBoundsRequest cbr, AbstractNodeEvent host) {
        RequestQuery requestQuery = new RequestQuery((Request)cbr);
        AbstractNodeEventResizeSelectionValidator validator = null;
        Object object = cbr.getExtendedData().get(EXECUTION_RESIZE_VALIDATOR);
        if (object instanceof AbstractNodeEventResizeSelectionValidator && !(validator = (AbstractNodeEventResizeSelectionValidator)object).getRequestQuery().getLogicalDelta().equals((Object)requestQuery.getLogicalDelta())) {
            validator = null;
        }
        if (validator == null && requestQuery.isResize()) {
            validator = new AbstractNodeEventResizeSelectionValidator(host, cbr);
            cbr.getExtendedData().put(EXECUTION_RESIZE_VALIDATOR, validator);
        }
        return validator;
    }

    private RequestQuery getRequestQuery() {
        return this.requestQuery;
    }

    public Collection<Integer> getInvalidPositions() {
        return this.invalidPositions;
    }

    private boolean checkGlobalPositions() {
        Option endMessage;
        Option startMessage;
        boolean safeMove = true;
        if (this.host instanceof Execution) {
            Execution exec = (Execution)this.host;
            startMessage = exec.getStartMessage();
            endMessage = exec.getEndMessage();
        } else {
            startMessage = Options.newNone();
            endMessage = Options.newNone();
        }
        Range actualRange = this.host.getVerticalRange();
        Rectangle newBounds = this.requestQuery.getLogicalTransformedRectangle(new Rectangle(0, actualRange.getLowerBound(), 0, actualRange.width()));
        if (newBounds.height < 0) {
            safeMove = false;
        } else {
            final Range finalRange = RangeHelper.verticalRange((Rectangle)newBounds);
            Function<ISequenceEvent, Range> futureRangeFunction = new Function<ISequenceEvent, Range>(){

                public Range apply(ISequenceEvent from) {
                    Range verticalRange = from.getVerticalRange();
                    if (AbstractNodeEventResizeSelectionValidator.this.host.equals((Object)from)) {
                        verticalRange = finalRange;
                    } else if (startMessage.some() && ((Message)startMessage.get()).equals((Object)from)) {
                        if (!((Message)startMessage.get()).isReflective()) {
                            verticalRange = new Range(finalRange.getLowerBound(), finalRange.getLowerBound());
                        } else if (AbstractNodeEventResizeSelectionValidator.this.requestQuery.isResizeFromTop()) {
                            verticalRange = AbstractNodeEventResizeSelectionValidator.this.requestQuery.isDirectedByMessage() ? new Range(verticalRange.getLowerBound(), verticalRange.getUpperBound() + ((AbstractNodeEventResizeSelectionValidator)AbstractNodeEventResizeSelectionValidator.this).requestQuery.getLogicalDelta().y) : verticalRange.shifted(((AbstractNodeEventResizeSelectionValidator)AbstractNodeEventResizeSelectionValidator.this).requestQuery.getLogicalDelta().y);
                        }
                    } else if (endMessage.some() && ((Message)endMessage.get()).equals((Object)from)) {
                        if (!((Message)endMessage.get()).isReflective()) {
                            verticalRange = new Range(finalRange.getUpperBound(), finalRange.getUpperBound());
                        } else if (AbstractNodeEventResizeSelectionValidator.this.requestQuery.isResizeFromBottom()) {
                            verticalRange = AbstractNodeEventResizeSelectionValidator.this.requestQuery.isDirectedByMessage() ? new Range(verticalRange.getLowerBound() + ((AbstractNodeEventResizeSelectionValidator)AbstractNodeEventResizeSelectionValidator.this).requestQuery.getLogicalDelta().height, verticalRange.getUpperBound()) : verticalRange.shifted(((AbstractNodeEventResizeSelectionValidator)AbstractNodeEventResizeSelectionValidator.this).requestQuery.getLogicalDelta().height);
                        }
                    } else if (from instanceof Operand && from.equals(AbstractNodeEventResizeSelectionValidator.this.host.getParentEvent())) {
                        verticalRange = finalRange.grown(5).union(verticalRange);
                    } else if (from instanceof CombinedFragment && AbstractNodeEventResizeSelectionValidator.this.host.getParentEvent() != null && from.equals(AbstractNodeEventResizeSelectionValidator.this.host.getParentEvent().getParentEvent())) {
                        verticalRange = finalRange.shifted(-35).union(verticalRange);
                    }
                    return verticalRange;
                }
            };
            this.invalidPositions.addAll(new PositionsChecker(this.host.getDiagram(), futureRangeFunction).getInvalidPositions());
            safeMove = this.invalidPositions.isEmpty();
        }
        return safeMove;
    }
}

