/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class CopyToClipboardAction
extends Action {
    private StructuredViewer fViewer;

    public CopyToClipboardAction(StructuredViewer viewer) {
        this();
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
    }

    public CopyToClipboardAction() {
        this.setText(SearchMessages.CopyToClipboardAction_label);
        this.setToolTipText(SearchMessages.CopyToClipboardAction_tooltip);
        ISharedImages workbenchImages = PlatformUI.getWorkbench().getSharedImages();
        this.setDisabledImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.setImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.setHoverImageDescriptor(workbenchImages.getImageDescriptor("IMG_TOOL_COPY"));
    }

    public void setViewer(StructuredViewer viewer) {
        this.fViewer = viewer;
    }

    public void runWithEvent(Event event) {
        Shell shell = SearchPlugin.getActiveWorkbenchShell();
        if (shell != null) {
            String sel = null;
            if (event.widget instanceof Combo) {
                Combo combo = (Combo)event.widget;
                sel = combo.getText();
                Point selection = combo.getSelection();
                sel = sel.substring(selection.x, selection.y);
            } else if (event.widget instanceof Text) {
                Text text = (Text)event.widget;
                sel = text.getSelectionText();
            }
            if (sel != null) {
                if (!sel.isEmpty()) {
                    this.copyToClipboard(sel, shell);
                }
                return;
            }
        }
        this.run();
    }

    public void run() {
        Shell shell = SearchPlugin.getActiveWorkbenchShell();
        if (shell == null || this.fViewer == null) {
            return;
        }
        IBaseLabelProvider labelProvider = this.fViewer.getLabelProvider();
        String lineDelim = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder();
        Iterator<?> iter = this.getSelection();
        while (iter.hasNext()) {
            if (buf.length() > 0) {
                buf.append(lineDelim);
            }
            buf.append(CopyToClipboardAction.getText(labelProvider, iter.next()));
        }
        if (buf.length() > 0) {
            this.copyToClipboard(buf.toString(), shell);
        }
    }

    private static String getText(IBaseLabelProvider labelProvider, Object object) {
        if (labelProvider instanceof ILabelProvider) {
            return ((ILabelProvider)labelProvider).getText(object);
        }
        if (labelProvider instanceof DelegatingStyledCellLabelProvider) {
            return ((DelegatingStyledCellLabelProvider)labelProvider).getStyledStringProvider().getStyledText(object).toString();
        }
        return object.toString();
    }

    private void copyToClipboard(String text, Shell shell) {
        text = TextProcessor.deprocess((String)text);
        Clipboard clipboard = new Clipboard(shell.getDisplay());
        try {
            this.copyToClipboard(clipboard, text, shell);
        }
        finally {
            clipboard.dispose();
        }
    }

    private Iterator<?> getSelection() {
        ISelection s = this.fViewer.getSelection();
        if (s instanceof IStructuredSelection) {
            return ((IStructuredSelection)s).iterator();
        }
        return Collections.emptyList().iterator();
    }

    private void copyToClipboard(Clipboard clipboard, String str, Shell shell) {
        block3: {
            try {
                clipboard.setContents((Object[])new String[]{str}, new Transfer[]{TextTransfer.getInstance()});
            }
            catch (SWTError ex) {
                if (ex.code != 2002) {
                    throw ex;
                }
                String title = SearchMessages.CopyToClipboardAction_error_title;
                String message = SearchMessages.CopyToClipboardAction_error_message;
                if (!MessageDialog.openQuestion((Shell)shell, (String)title, (String)message)) break block3;
                this.copyToClipboard(clipboard, str, shell);
            }
        }
    }
}

