/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.sdk.s2e.job.AbstractJob;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.scout.sdk.s2e.util.EclipseWorkspaceWalker;
import org.eclipse.search.ui.text.Match;

public class NlsFindKeysJob
extends AbstractJob {
    private final List<char[]> m_searchKeys;
    private final Map<String, List<Match>> m_matches;

    public NlsFindKeysJob(String nlsKey, String jobTitle) {
        this(Collections.singletonList(nlsKey), jobTitle);
    }

    public NlsFindKeysJob(INlsProject project, String jobTitle) {
        this(NlsFindKeysJob.getLocalKeys(project), jobTitle);
    }

    protected NlsFindKeysJob(Collection<String> searchKeys, String jobTitle) {
        super(jobTitle);
        this.m_searchKeys = new ArrayList<char[]>(searchKeys.size() * 2);
        for (String key : searchKeys) {
            this.m_searchKeys.add((String.valueOf('\"') + key + '\"').toCharArray());
            this.m_searchKeys.add((String.valueOf('\'') + key + '\'').toCharArray());
        }
        this.m_matches = new HashMap<String, List<Match>>();
    }

    private static List<String> getLocalKeys(INlsProject project) {
        return project.getAllEntries().stream().filter(entry -> entry.getType() == 1).map(INlsEntry::getKey).collect(Collectors.toList());
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        this.m_matches.clear();
        new EclipseWorkspaceWalker(this.getName()).withExtensionsAccepted(new String[]{"java", "js", "html", "less", "json", "xml", "sql", "css", "svg", "txt", "jsp"}).walk(this::searchInFile, monitor);
    }

    protected void searchInFile(EclipseWorkspaceWalker.WorkspaceFile file) {
        for (char[] search : this.m_searchKeys) {
            int index;
            int pos = 0;
            while ((index = CharOperation.indexOf((char[])search, (char[])file.content(), (boolean)true, (int)pos)) >= 0) {
                if (file.inWorkspace().isPresent()) {
                    Match match = new Match(file.inWorkspace().get(), index, search.length);
                    String key = String.valueOf(search, 1, search.length - 2);
                    this.acceptNlsKeyMatch(key, match);
                }
                pos = index + search.length;
            }
        }
    }

    protected void acceptNlsKeyMatch(String nlsKey, Match match) {
        this.m_matches.computeIfAbsent(nlsKey, key -> new ArrayList()).add(match);
    }

    public List<Match> getMatches(String nlsKey) {
        List<Match> list = this.m_matches.get(nlsKey);
        if (list == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Match>(list);
    }

    public Map<String, List<Match>> getAllMatches() {
        return new HashMap<String, List<Match>>(this.m_matches);
    }
}

