/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.wst.server.ui.cnf;

import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.jface.handler.TreeViewerHandler;
import org.eclipse.reddeer.swt.api.TreeItem;

public abstract class AbstractLabel {
    private TreeViewerHandler treeViewerHandler = TreeViewerHandler.getInstance();
    protected String name;
    protected ServersViewEnums.ServerState state = ServersViewEnums.ServerState.NONE;
    protected ServersViewEnums.ServerPublishState status = ServersViewEnums.ServerPublishState.NONE;

    protected abstract void parseSingleStateDecoration(String var1);

    protected void parse(TreeItem item) {
        this.name = this.treeViewerHandler.getNonStyledText(item);
        String[] styledTexts = this.treeViewerHandler.getStyledTexts(item);
        if (styledTexts != null) {
            this.parseDecoration(styledTexts[0]);
        }
    }

    private void parseDecoration(String styledText) {
        if (styledText.contains(",")) {
            this.state = ServersViewEnums.ServerState.getByText(styledText.substring(styledText.indexOf("[") + 1, styledText.lastIndexOf(",")).trim());
            this.status = ServersViewEnums.ServerPublishState.getByText(styledText.substring(styledText.indexOf(",") + 1, styledText.lastIndexOf("]")).trim());
        } else {
            this.parseSingleStateDecoration(styledText.substring(styledText.indexOf("[") + 1, styledText.lastIndexOf("]")).trim());
        }
    }

    public String getName() {
        return this.name;
    }

    public ServersViewEnums.ServerState getState() {
        return this.state;
    }

    public ServersViewEnums.ServerPublishState getPublishState() {
        return this.status;
    }
}

