/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.reddeer.core.handler.ItemHandler;
import org.eclipse.reddeer.core.handler.TreeHandler;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class TreeItemHandler
extends ItemHandler {
    private static final Logger logger = Logger.getLogger(TreeItemHandler.class);
    private static TreeItemHandler instance;

    public static TreeItemHandler getInstance() {
        if (instance == null) {
            instance = new TreeItemHandler();
        }
        return instance;
    }

    public String getText(final TreeItem treeItem, final int cellIndex) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return treeItem.getText(cellIndex);
            }
        });
        return text;
    }

    public String getToolTipText(final TreeItem item) {
        String text = (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return item.getParent().getToolTipText();
            }
        });
        return text;
    }

    public boolean isExpanded(final TreeItem item) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return item.getExpanded();
            }
        });
    }

    public void setText(final TreeItem treeItem, final int cellIndex, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                treeItem.setText(cellIndex, text);
            }
        });
    }

    public void selectItems(final TreeItem ... selection) {
        logger.info("Select tree items: ");
        final Tree swtTree = this.getParent(selection[0]);
        TreeHandler.getInstance().setFocus((Control)swtTree);
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (2 != (swtTree.getStyle() & 2) && selection.length > 1) {
                    throw new CoreLayerException("Tree does not support SWT.MULTI, cannot make multiple selections");
                }
                logger.debug("Set Tree selection");
                swtTree.setSelection(selection);
            }
        });
        TreeHandler.getInstance().notifySelect(swtTree);
        logger.debug("Selected Tree Items:");
        TreeItem[] treeItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            logger.debug("  " + this.getText((Item)treeItem));
            ++n2;
        }
    }

    public void select(final TreeItem swtTreeItem) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                logger.debug("Selecting tree item: " + swtTreeItem.getText());
                swtTreeItem.getParent().setFocus();
                swtTreeItem.getParent().setSelection(swtTreeItem);
            }
        });
        logger.debug("Notify tree item " + this.getText((Item)swtTreeItem) + " about selection");
        TreeHandler.getInstance().notifyTree(swtTreeItem, TreeHandler.getInstance().createEventForTree(swtTreeItem, 13));
        logger.info("Selected tree item: " + this.getText((Item)swtTreeItem));
    }

    public TreeItem getItem(final TreeItem swtTreeItem, final String text) {
        logger.debug("Get child tree item " + text + " of tree item " + this.getText((Item)swtTreeItem));
        this.expand(swtTreeItem);
        TreeItem result = (TreeItem)Display.syncExec((ResultRunnable)new ResultRunnable<TreeItem>(){

            public TreeItem run() {
                TreeItem[] items = swtTreeItem.getItems();
                boolean isFound = false;
                int index = 0;
                while (!isFound && index < items.length) {
                    if (items[index].getText().equals(text)) {
                        isFound = true;
                        continue;
                    }
                    ++index;
                }
                if (!isFound) {
                    return null;
                }
                return items[index];
            }
        });
        if (result != null) {
            return result;
        }
        CoreLayerException exception = new CoreLayerException("Tree Item " + this + " has no Tree Item with text " + text);
        exception.addMessageDetail("Tree Item " + this + " has these direct children:");
        for (TreeItem treeItem : TreeHandler.getInstance().getSWTItems(this.getParent(swtTreeItem))) {
            exception.addMessageDetail("  " + this.getText(treeItem, 0));
        }
        throw exception;
    }

    public List<TreeItem> getChildrenItems(final TreeItem swtTreeItem) {
        this.expand(swtTreeItem, TimePeriod.SHORT);
        return (List)Display.syncExec((ResultRunnable)new ResultRunnable<List<TreeItem>>(){

            public List<TreeItem> run() {
                TreeItem[] items = swtTreeItem.getItems();
                return Arrays.asList(items);
            }
        });
    }

    public Tree getParent(final TreeItem swtTreeItem) {
        return (Tree)Display.syncExec((ResultRunnable)new ResultRunnable<Tree>(){

            public Tree run() {
                return swtTreeItem.getParent();
            }
        });
    }

    public TreeItem getParentItem(final TreeItem swtTreeItem) {
        return (TreeItem)Display.syncExec((ResultRunnable)new ResultRunnable<TreeItem>(){

            public TreeItem run() {
                return swtTreeItem.getParentItem();
            }
        });
    }

    public String[] getPath(final TreeItem swtTreeItem) {
        return (String[])Display.syncExec((ResultRunnable)new ResultRunnable<String[]>(){

            public String[] run() {
                TreeItem swttiDummy = swtTreeItem;
                LinkedList<String> items = new LinkedList<String>();
                while (swttiDummy != null) {
                    items.addFirst(swttiDummy.getText());
                    swttiDummy = swttiDummy.getParentItem();
                }
                return items.toArray(new String[0]);
            }
        });
    }

    public boolean isChecked(final TreeItem swtTreeItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return swtTreeItem.getChecked();
            }
        });
    }

    public void setChecked(final TreeItem swtTreeItem, final boolean check) {
        logger.debug(String.valueOf(check ? "Check" : "Uncheck") + "Tree Item " + this.getText((Item)swtTreeItem) + ":");
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.setChecked(check);
            }
        });
        logger.debug("Notify tree about check event");
        TreeHandler.getInstance().notifyTree(swtTreeItem, TreeHandler.getInstance().createEventForTree(swtTreeItem, 13, 32));
        logger.info(String.valueOf(check ? "Checked: " : "Unchecked: ") + this.getText((Item)swtTreeItem));
    }

    public boolean isSelected(final TreeItem swtTreeItem) {
        return (Boolean)Display.syncExec((ResultRunnable)new ResultRunnable<Boolean>(){

            public Boolean run() {
                return Arrays.asList(swtTreeItem.getParent().getSelection()).contains(swtTreeItem);
            }
        });
    }

    public void collapse(final TreeItem swtTreeItem) {
        logger.debug("Collapse Tree Item " + this.getText((Item)swtTreeItem));
        if (this.isExpanded(swtTreeItem)) {
            Display.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    logger.debug("Setting tree item " + swtTreeItem.getText() + " collapsed");
                    swtTreeItem.setExpanded(false);
                }
            });
            logger.debug("Notify tree about collapse event");
            TreeHandler.getInstance().notifyTree(swtTreeItem, TreeHandler.getInstance().createEventForTree(swtTreeItem, 18));
        } else {
            logger.debug("Tree Item " + this.getText((Item)swtTreeItem) + " is already collapsed. No action performed");
        }
        logger.info("Collapsed: " + this.getText((Item)swtTreeItem));
    }

    public void expand(TreeItem swtTreeItem) {
        this.expand(swtTreeItem, TimePeriod.SHORT);
    }

    public void expand(final TreeItem swtTreeItem, TimePeriod timePeriod) {
        logger.debug("Expand Tree Item " + this.getText((Item)swtTreeItem));
        final TreeExpandListener tel = new TreeExpandListener();
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.getParent().addListener(17, (Listener)tel);
            }
        });
        try {
            new WaitUntil((WaitCondition)new TreeHeardExpandNotification(swtTreeItem, tel, false), timePeriod);
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            new WaitUntil((WaitCondition)new TreeHeardExpandNotification(swtTreeItem, tel, true), timePeriod);
        }
        logger.info("Expanded: " + this.getText((Item)swtTreeItem));
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                swtTreeItem.setExpanded(true);
                swtTreeItem.getParent().update();
            }
        });
    }

    public void click(TreeItem swtTreeItem) {
        Rectangle bounds = this.getBounds(swtTreeItem);
        this.notifyMouseClick(swtTreeItem, bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
    }

    public Rectangle getBounds(final TreeItem swtTreeItem) {
        return (Rectangle)Display.syncExec((ResultRunnable)new ResultRunnable<Rectangle>(){

            public Rectangle run() {
                return swtTreeItem.getBounds();
            }
        });
    }

    private void notifyMouseClick(TreeItem swtTreeItem, int x, int y) {
        TreeHandler.getInstance().notifyTree(swtTreeItem, 3, this.createMouseEvent(swtTreeItem, null, 0, x, y, 1, 0, 1));
        TreeHandler.getInstance().notifyTree(swtTreeItem, 4, this.createMouseEvent(swtTreeItem, null, 0, x, y, 1, 524288, 1));
    }

    private Event createMouseEvent(TreeItem swtTreeItem, Widget item, int type, int x, int y, int button, int stateMask, int count) {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        event.widget = swtTreeItem;
        event.display = Display.getDisplay();
        event.x = x;
        event.y = y;
        event.button = button;
        event.stateMask = stateMask;
        event.count = count;
        event.item = item;
        event.type = type;
        return event;
    }

    public void setFocus(TreeItem swtItem) {
        new ControlHandler().setFocus((Control)this.getParent(swtItem));
    }

    private class TreeExpandListener
    implements Listener {
        private boolean heard = false;

        private TreeExpandListener() {
        }

        public void handleEvent(Event arg0) {
            this.heard = true;
        }

        public boolean isHeard() {
            return this.heard;
        }
    }

    private class TreeHeardExpandNotification
    extends AbstractWaitCondition {
        private TreeItem treeItem;
        private TreeExpandListener listener;
        private boolean sync;

        public TreeHeardExpandNotification(TreeItem treeItem, TreeExpandListener listener, boolean sync) {
            this.treeItem = treeItem;
            this.listener = listener;
            this.sync = sync;
        }

        public boolean test() {
            if (!TreeItemHandler.this.isExpanded(this.treeItem)) {
                if (this.sync) {
                    TreeHandler.getInstance().notifyTreeSync(this.treeItem, TreeHandler.getInstance().createEventForTree(this.treeItem, 17));
                } else {
                    TreeHandler.getInstance().notifyTree(this.treeItem, TreeHandler.getInstance().createEventForTree(this.treeItem, 17));
                }
                return this.listener.isHeard();
            }
            logger.debug("Tree Item " + TreeItemHandler.this.getText((Item)this.treeItem) + " is already expanded. No action performed");
            return true;
        }

        public String description() {
            return "tree heard expand notification";
        }
    }
}

