/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.ptp.pldt.mpi.analysis.cdt.graphs.IBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Block
implements IBlock {
    protected List<IBlock> succs_;
    protected List<IBlock> preds_;
    protected IBlock topNext_ = null;
    protected IBlock botNext_ = null;
    protected List<IBlock> DOM_ = null;
    protected List<IBlock> PDOM_ = null;
    protected static int counter = 0;
    protected int id = counter++;
    protected int type = 0;
    public static final int expr_type = 1;
    public static final int stmt_type = 2;
    public static final int label_type = 3;
    public static final int continue_join_type = 4;
    public static final int exit_join_type = 5;
    protected IASTNode content_ = null;
    protected IASTStatement parent_ = null;
    protected Hashtable<String, Object> attrs_;
    int color;

    public Block() {
        this.blockInit();
    }

    public Block(IASTNode content, IASTStatement parent, int type) {
        this();
        this.content_ = content;
        this.parent_ = parent;
        this.type = type;
        this.blockInit();
    }

    public Block(IASTStatement stmt) {
        this((IASTNode)stmt, stmt, 2);
    }

    public Block(IASTExpression expr, IASTStatement parent) {
        this((IASTNode)expr, parent, 1);
    }

    public Block(IASTName label) {
        this((IASTNode)label, null, 3);
    }

    protected void blockInit() {
        this.succs_ = new ArrayList<IBlock>();
        this.preds_ = new ArrayList<IBlock>();
        this.DOM_ = new ArrayList<IBlock>();
        this.PDOM_ = new ArrayList<IBlock>();
        this.attrs_ = new Hashtable();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public IASTNode getContent() {
        return this.content_;
    }

    public IASTStatement getParent() {
        return this.parent_;
    }

    public int getType() {
        return this.type;
    }

    public boolean search(IASTNode content, IASTStatement parent, int type) {
        if (this.type != type) {
            return false;
        }
        if (type == 2) {
            return content == this.content_;
        }
        if (type == 3) {
            if (content instanceof IASTName) {
                IASTName name = (IASTName)content;
                IASTName labelName = (IASTName)this.content_;
                return name.toString().equals(labelName.toString());
            }
            return false;
        }
        if (type == 1) {
            if (content != null && content == this.content_) {
                return true;
            }
            return content == null && this.content_ == null && this.parent_ == parent;
        }
        if (type == 4 || type == 5) {
            if (content != null) {
                return false;
            }
            return parent == this.parent_;
        }
        return false;
    }

    @Override
    public boolean search(IASTExpression expr, IASTStatement parent) {
        return this.search((IASTNode)expr, parent, 1);
    }

    @Override
    public boolean search(IASTStatement stmt) {
        return this.search((IASTNode)stmt, stmt, 2);
    }

    @Override
    public boolean search(IASTName label) {
        return this.search((IASTNode)label, null, 3);
    }

    @Override
    public IBlock topNext() {
        return this.topNext_;
    }

    @Override
    public IBlock getTopNext() {
        return this.topNext_;
    }

    @Override
    public void setTopNext(IBlock b) {
        this.topNext_ = b;
    }

    @Override
    public IBlock botNext() {
        return this.botNext_;
    }

    @Override
    public IBlock getBotNext() {
        return this.botNext_;
    }

    @Override
    public void setBotNext(IBlock b) {
        this.botNext_ = b;
    }

    @Override
    public List<IBlock> getPreds() {
        return this.preds_;
    }

    @Override
    public List<IBlock> getSuccs() {
        return this.succs_;
    }

    @Override
    public List<IBlock> getDOM() {
        return this.DOM_;
    }

    @Override
    public void setDOM(List<IBlock> set) {
        this.DOM_ = set;
    }

    @Override
    public List<IBlock> getPDOM() {
        return this.PDOM_;
    }

    @Override
    public void setPDOM(List<IBlock> set) {
        this.PDOM_ = set;
    }

    @Override
    public void setAttr(String name, Object attr) {
        this.attrs_.put(name, attr);
    }

    @Override
    public Object getAttr(String name) {
        return this.attrs_.get(name);
    }

    @Override
    public void print() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Block " + this.id + ": ");
        IASTNode content = this.getContent();
        if (content != null) {
            String type = content.toString();
            type = type.substring(type.lastIndexOf(46) + 1);
            type = type.substring(0, type.indexOf(64));
            buf.append("  " + type + "  " + content.getRawSignature() + "\n");
        } else {
            buf.append("  Empty block");
            buf.append("\n");
        }
        buf.append("  flows to: ");
        Iterator<IBlock> i = this.succs_.iterator();
        while (i.hasNext()) {
            buf.append(String.valueOf(i.next().getID()) + ", ");
        }
        buf.append(" \n");
        return buf.toString();
    }
}

