/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.tar;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dltk.core.IArchive;
import org.eclipse.dltk.core.IArchiveEntry;
import org.eclipse.php.internal.core.tar.TarArchiveEntry;
import org.eclipse.php.internal.core.tar.TarEntry;
import org.eclipse.php.internal.core.tar.TarException;
import org.eclipse.php.internal.core.tar.TarFile;

public class TarArchiveFile
implements IArchive {
    private TarFile tarFile;
    private boolean mapInited = false;
    private Map<String, TarArchiveEntry> map = new HashMap<String, TarArchiveEntry>();

    public TarArchiveFile(String filename) throws TarException, IOException {
        this.tarFile = new TarFile(filename);
    }

    public TarArchiveFile(File file) throws TarException, IOException {
        this.tarFile = new TarFile(file);
    }

    public Enumeration<? extends IArchiveEntry> getArchiveEntries() {
        final Enumeration<Object> e = this.tarFile.entries();
        return new Enumeration<IArchiveEntry>(){

            @Override
            public boolean hasMoreElements() {
                return e.hasMoreElements();
            }

            @Override
            public IArchiveEntry nextElement() {
                TarEntry tarEntry = (TarEntry)e.nextElement();
                if (TarArchiveFile.this.map.containsKey(tarEntry.getName())) {
                    return (IArchiveEntry)TarArchiveFile.this.map.get(tarEntry.getName());
                }
                TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(tarEntry);
                TarArchiveFile.this.map.put(tarArchiveEntry.getName(), tarArchiveEntry);
                return tarArchiveEntry;
            }
        };
    }

    public IArchiveEntry getArchiveEntry(String name) {
        this.initMap();
        return this.map.get(name);
    }

    private void initMap() {
        if (this.mapInited) {
            return;
        }
        Enumeration<? extends IArchiveEntry> e = this.getArchiveEntries();
        while (e.hasMoreElements()) {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)e.nextElement();
            this.map.put(tarArchiveEntry.getName(), tarArchiveEntry);
        }
        this.mapInited = true;
    }

    public InputStream getInputStream(IArchiveEntry entry) throws IOException {
        if (entry instanceof TarArchiveEntry) {
            TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)entry;
            try {
                return this.tarFile.getInputStream(tarArchiveEntry.getTarEntry());
            }
            catch (TarException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void close() throws IOException {
        this.tarFile.close();
    }

    public String getName() {
        return this.tarFile.getName();
    }

    public int fileSize() {
        this.initMap();
        return this.map.size();
    }
}

