/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.markers.SinceTagResolution;
import org.eclipse.pde.api.tools.ui.internal.markers.VersionNumberingResolution;
import org.osgi.framework.Version;

public class SinceTagAfterVersionUpdateResolution
extends SinceTagResolution {
    IMarker markerVersion = null;

    public SinceTagAfterVersionUpdateResolution(IMarker markerVer, IMarker marker) {
        super(marker);
        this.markerVersion = markerVer;
    }

    @Override
    public String getLabel() {
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag_after_version_update, (Object)this.markerVersion.getAttribute("version", null));
    }

    @Override
    public void run(IMarker marker) {
        if (this.markerVersion != null) {
            new VersionNumberingResolution(this.markerVersion).run(this.markerVersion);
            String componentVersionString = this.markerVersion.getAttribute("version", null);
            StringBuilder buffer = new StringBuilder();
            Version componentVersion = new Version(componentVersionString);
            buffer.append(componentVersion.getMajor()).append('.').append(componentVersion.getMinor());
            try {
                this.markerVersion.setAttribute("version", (Object)buffer.toString());
            }
            catch (CoreException e) {
                ApiUIPlugin.log(e);
            }
            this.newVersionValue = this.markerVersion.getAttribute("version", null);
        }
        super.run(marker);
    }

    @Override
    public String getDescription() {
        return NLS.bind((String)MarkerMessages.SinceTagResolution_add_since_tag_after_version_update, (Object)this.markerVersion.getAttribute("version", null));
    }
}

