/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.service;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.decoration.UndefinedProfileMarker;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.service.IProfileDefinitionService;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;

public class ProfileDefinitionService
implements IService,
IProfileDefinitionService {
    private ModelSet modelSet = null;
    private static Map<Profile, IPapyrusMarker> mapInstance = new HashMap<Profile, IPapyrusMarker>();

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.modelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
    }

    public void startService() throws ServiceException {
        final UmlModel umlModel = (UmlModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
        try {
            if (umlModel.getResource() != null && umlModel.getResource().getContents().isEmpty()) {
                final Resource res = umlModel.getResource();
                AdapterImpl waitingForRootAdapter = new AdapterImpl(){

                    public void notifyChanged(Notification msg) {
                        if (msg.getNewValue() instanceof Element && 3 == msg.getEventType() && res.getContents().size() > 0) {
                            try {
                                try {
                                    ProfileDefinitionService.this.addRootProfileDecorationIfRequired(umlModel);
                                }
                                catch (NotFoundException | ServiceException e) {
                                    Activator.log.error(e);
                                    res.eAdapters().remove((Object)this);
                                }
                            }
                            finally {
                                res.eAdapters().remove((Object)this);
                            }
                        }
                    }
                };
                res.eAdapters().add((Object)waitingForRootAdapter);
            } else {
                this.addRootProfileDecorationIfRequired(umlModel);
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private final void addRootProfileDecorationIfRequired(UmlModel umlModel) throws NotFoundException, ServiceException {
        PapyrusDefinitionAnnotation parsedAnnotation;
        EAnnotation emptyAnnotation;
        EAnnotation umlAnnotation;
        EObject rootElement = umlModel.lookupRoot();
        if (rootElement instanceof Profile && (umlAnnotation = ((Profile)rootElement).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && !umlAnnotation.getEAnnotations().isEmpty() && (emptyAnnotation = umlAnnotation.getEAnnotation("PapyrusVersion")) != null && PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.equals(parsedAnnotation = PapyrusDefinitionAnnotation.parseEAnnotation(emptyAnnotation))) {
            DecorationService decorationService = (DecorationService)ServiceUtilsForEObject.getInstance().getService(DecorationService.class, (Object)rootElement);
            decorationService.addDecoration(this.getMarker((Profile)rootElement), rootElement);
        }
    }

    public void disposeService() throws ServiceException {
        mapInstance.clear();
    }

    @Override
    public IPapyrusMarker getMarker(Profile profile) {
        IPapyrusMarker marker = mapInstance.get(profile);
        if (marker == null) {
            marker = new UndefinedProfileMarker(profile);
            mapInstance.put(profile, marker);
        }
        return marker;
    }

    @Override
    public void disposeMarker(Profile profile) {
        mapInstance.remove(profile);
    }
}

