/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.eventbus.EventBus;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.preferences.ProfileExternalizationUIPreferences;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers.DecoratorModelLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractProfileApplicationSelectionPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.uml2.uml.Package;

public class DecoratorModelSelectionPage
extends WizardPage {
    private boolean showDontShowThis;
    protected CheckboxTableViewer table;
    private ResourceSet resourceSet;
    private Set<URI> input;
    private Set<IFile> initialSelections;
    private final EventBus bus;

    public DecoratorModelSelectionPage(EventBus bus) {
        this(bus, null);
    }

    public DecoratorModelSelectionPage(EventBus bus, ImageDescriptor titleImage) {
        this("selection", Messages.DecoratorModelSelectionPage_0, bus, titleImage);
    }

    protected DecoratorModelSelectionPage(String name, String title, EventBus bus, ImageDescriptor titleImage) {
        super(name, title, titleImage);
        this.bus = bus;
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new GridLayout());
        AbstractProfileApplicationSelectionPage.label(main, Messages.DecoratorModelSelectionPage_1);
        this.table = new CheckboxTableViewer(new Table(main, 2848));
        AbstractProfileApplicationSelectionPage.fill(this.table.getTable(), true, true);
        this.table.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratorModelLabelProvider(this.resourceSet)));
        this.table.setContentProvider((IContentProvider)new AvailableResourcesContentProvider());
        this.table.setInput(this.getInput());
        if (this.initialSelections != null) {
            this.table.setCheckedElements(Iterables.toArray(this.initialSelections, IFile.class));
        }
        this.table.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DecoratorModelSelectionPage.this.validatePage();
            }
        });
        this.createSelectionButtons(main);
        if (this.showDontShowThis()) {
            this.createPreferenceArea(main);
        }
        this.setControl((Control)main);
        this.validatePage();
    }

    IFile[] getCheckedFiles() {
        List<Object> checked = this.table == null ? (this.initialSelections == null ? Collections.emptyList() : ImmutableList.copyOf(this.initialSelections)) : Arrays.asList(this.table.getCheckedElements());
        return (IFile[])Iterables.toArray((Iterable)Iterables.filter(checked, IFile.class), IFile.class);
    }

    protected void createSelectionButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        AbstractProfileApplicationSelectionPage.align(buttons, 131072);
        RowLayout layout = new RowLayout();
        layout.marginLeft = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginBottom = 0;
        buttons.setLayout((Layout)layout);
        this.createSpecialSelectionButtons(buttons);
        class ButtonHandler
        extends SelectionAdapter {
            final boolean select;

            ButtonHandler(boolean select) {
                this.select = select;
            }

            public void widgetSelected(SelectionEvent e) {
                DecoratorModelSelectionPage.this.table.setAllChecked(this.select);
                DecoratorModelSelectionPage.this.validatePage();
            }
        }
        AbstractProfileApplicationSelectionPage.button(buttons, Messages.DecoratorModelSelectionPage_2).addSelectionListener((SelectionListener)new ButtonHandler(true));
        AbstractProfileApplicationSelectionPage.button(buttons, Messages.DecoratorModelSelectionPage_3).addSelectionListener((SelectionListener)new ButtonHandler(false));
    }

    protected void createSpecialSelectionButtons(Composite buttons) {
    }

    protected void createPreferenceArea(Composite parent) {
        final boolean[] preference = new boolean[1];
        final Button dontShowThisButton = new Button(parent, 32);
        dontShowThisButton.setText(Messages.DecoratorModelSelectionPage_4);
        dontShowThisButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                preference[0] = dontShowThisButton.getSelection();
            }
        });
        dontShowThisButton.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DecoratorModelSelectionPage.this.storeDontShowThisPreference(preference[0]);
            }
        });
    }

    protected void storeDontShowThisPreference(boolean dontShowThisAgain) {
        ProfileExternalizationUIPreferences.setAutoPromptToLoadProfileApplications(!dontShowThisAgain);
    }

    public void setIsAutomaticPrompt(boolean autoPrompt) {
        this.showDontShowThis = autoPrompt;
    }

    protected boolean showDontShowThis() {
        return this.showDontShowThis;
    }

    public void setInput(Package package_, Set<URI> input) {
        this.input = input;
        if (package_ != null) {
            this.resourceSet = EMFHelper.getResourceSet((EObject)package_);
        }
        if (this.table != null) {
            this.table.setInput(input);
        }
        this.validatePage();
    }

    public Set<URI> getInput() {
        return this.input;
    }

    public void select(Iterable<URI> resources) {
        Set<IFile> files = DecoratorModelSelectionPage.urisToFiles(resources);
        if (!files.equals(this.initialSelections)) {
            this.initialSelections = DecoratorModelSelectionPage.urisToFiles(resources);
            if (this.table != null) {
                this.table.setCheckedElements(Iterables.toArray(files, IFile.class));
            }
            this.bus.post(this.initialSelections);
            this.validatePage();
        }
    }

    void validatePage() {
        this.setErrorMessage(null);
        IFile[] checked = this.getCheckedFiles();
        this.bus.post((Object)this.getCheckedFiles());
        if (this.input == null || this.input.isEmpty()) {
            this.setErrorMessage(Messages.DecoratorModelSelectionPage_5);
            this.setPageComplete(false);
        } else if (checked.length == 0) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    static Set<IFile> urisToFiles(Iterable<URI> uris) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        for (URI next : uris) {
            IFile file;
            if (!next.isPlatformResource() || (file = root.getFile((IPath)new Path(next.toPlatformString(true)))) == null || !file.exists()) continue;
            result.add(file);
        }
        return result;
    }

    static IFile[] urisToFilesArray(Iterable<URI> uris) {
        return (IFile[])Iterables.toArray(DecoratorModelSelectionPage.urisToFiles(uris), IFile.class);
    }

    static class AvailableResourcesContentProvider
    implements ITreeContentProvider {
        private final IFile[] none = new IFile[0];

        AvailableResourcesContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = this.none;
            if (inputElement instanceof Collection) {
                result = DecoratorModelSelectionPage.urisToFilesArray(Iterables.filter((Iterable)((Collection)inputElement), URI.class));
                Arrays.sort(result, new Comparator<IFile>(){

                    @Override
                    public int compare(IFile o1, IFile o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
            }
            return result;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return this.none;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

