/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.edit.context;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.IClientContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.core.architecture.ArchitectureDescription;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.services.edit.internal.context.DefaultTypeContext;
import org.eclipse.papyrus.infra.services.edit.messages.Messages;

public class TypeContext {
    public static IClientContext getDefaultContext() throws ServiceException {
        return DefaultTypeContext.getContext();
    }

    public static String getDefaultContextId() {
        return "org.eclipse.papyrus.infra.services.edit.TypeContext";
    }

    public static IClientContext getContext(ModelSet modelSet) throws ServiceException {
        ArchitectureDescription desc = DiModelUtils.getArchitectureDescription((ModelSet)modelSet);
        if (desc != null) {
            return TypeContext.getContext(desc.getContextId());
        }
        return TypeContext.getDefaultContext();
    }

    public static IClientContext getContext(ResourceSet resoureSet) throws ServiceException {
        if (resoureSet instanceof ModelSet) {
            return TypeContext.getContext((ModelSet)resoureSet);
        }
        return TypeContext.getDefaultContext();
    }

    public static IClientContext getContext(EditingDomain editingDomain) throws ServiceException {
        if (editingDomain.getResourceSet() != null) {
            return TypeContext.getContext(editingDomain.getResourceSet());
        }
        return TypeContext.getDefaultContext();
    }

    public static IClientContext getContext(Resource resource) throws ServiceException {
        if (resource.getResourceSet() != null) {
            return TypeContext.getContext(resource.getResourceSet());
        }
        return TypeContext.getDefaultContext();
    }

    public static IClientContext getContext(EObject object) throws ServiceException {
        if (object.eResource() != null) {
            return TypeContext.getContext(object.eResource());
        }
        return TypeContext.getDefaultContext();
    }

    public static IClientContext getContext(String contextId) throws ServiceException {
        IClientContext context = ClientContextManager.getInstance().getClientContext(contextId);
        if (context == null) {
            throw new ServiceException(NLS.bind((String)Messages.TypeContext_ContextNotFound, (Object)contextId));
        }
        return context;
    }
}

