/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.interpreter.console.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.ocl.examples.interpreter.console.text.OCLDocument;
import org.eclipse.ocl.helper.Choice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OCLCompletionProcessor
implements IContentAssistProcessor {
    private static char[] NO_CHARS = new char[0];
    private static IContextInformation[] NO_CONTEXTS = new IContextInformation[0];
    private static ICompletionProposal[] NO_COMPLETIONS = new ICompletionProposal[0];
    private static char[] ACTIVATION = new char[]{'.', ':', '>', '^'};

    OCLCompletionProcessor() {
    }

    /*
     * Unable to fully structure code
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        doc = (OCLDocument)viewer.getDocument();
        replacementOffset = offset;
        try {
            if (offset > 0 && doc.getChar(offset - 1) == '>' && (offset < 2 || doc.getChar(offset - 2) != '-')) {
                return OCLCompletionProcessor.NO_COMPLETIONS;
            }
            if (offset <= 0 || doc.getChar(offset - 1) != ':' || offset >= 2 && doc.getChar(offset - 2) == ':') ** GOTO lbl-1000
            return OCLCompletionProcessor.NO_COMPLETIONS;
            {
                trigger = doc.getChar(--replacementOffset);
                switch (trigger) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case '(': 
                    case '.': 
                    case ':': 
                    case '>': 
                    case '[': 
                    case '^': 
                    case '{': {
                        ++replacementOffset;
                        break block5;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (replacementOffset > 0) continue block5;
                        break block5;
                    }
                }
            }
        }
        catch (BadLocationException e) {
            return OCLCompletionProcessor.NO_COMPLETIONS;
        }
        choices = doc.getOCLChoices(offset);
        return this.createCompletions(choices, replacementOffset, offset - replacementOffset);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ACTIVATION;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return NO_CONTEXTS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return NO_CHARS;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    private ICompletionProposal[] createCompletions(List<Choice> choices, int replacementOffset, int replacementLength) {
        ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
        this.sortChoices(choices);
        for (Choice choice : choices) {
            int cursor;
            String display;
            String text = choice.getName();
            switch (choice.getKind()) {
                case OPERATION: 
                case SIGNAL: {
                    text = String.valueOf(text) + "()";
                    display = choice.getDescription();
                    cursor = text.length() - 1;
                    break;
                }
                case PROPERTY: 
                case ENUMERATION_LITERAL: 
                case ASSOCIATION_CLASS: 
                case VARIABLE: {
                    display = String.valueOf(text) + " : " + choice.getDescription();
                    cursor = text.length();
                    break;
                }
                default: {
                    display = text;
                    cursor = text.length();
                }
            }
            result.add(new CompletionProposal(text, replacementOffset, replacementLength, cursor, null, display, null, null));
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private void sortChoices(List<Choice> choices) {
        Collections.sort(choices, new Comparator<Choice>(){

            @Override
            public int compare(Choice o1, Choice o2) {
                int result = this.rank(o1) - this.rank(o2);
                if (result == 0) {
                    result = o1.getName().compareTo(o2.getName());
                }
                return result;
            }

            private int rank(Choice choice) {
                switch (choice.getKind()) {
                    case VARIABLE: {
                        return 0;
                    }
                    case PACKAGE: {
                        return 1;
                    }
                    case TYPE: {
                        return 2;
                    }
                    case ENUMERATION_LITERAL: {
                        return 3;
                    }
                    case STATE: {
                        return 4;
                    }
                    case PROPERTY: {
                        return 5;
                    }
                    case ASSOCIATION_CLASS: {
                        return 6;
                    }
                    case OPERATION: {
                        return 7;
                    }
                    case SIGNAL: {
                        return 8;
                    }
                }
                return Integer.MAX_VALUE;
            }
        });
    }
}

