/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import org.eclipse.net4j.util.security.IPasswordCredentials;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.PasswordCredentials;

public class PasswordCredentialsProvider
implements IPasswordCredentialsProvider {
    private IPasswordCredentials credentials;

    public PasswordCredentialsProvider() {
    }

    public PasswordCredentialsProvider(IPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public PasswordCredentialsProvider(String userID, char[] password) {
        this(new PasswordCredentials(userID, password));
    }

    public PasswordCredentialsProvider(String userID, String password) {
        this(userID, password == null ? null : password.toCharArray());
    }

    public boolean isInteractive() {
        return false;
    }

    public IPasswordCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(IPasswordCredentials credentials) {
        this.credentials = credentials;
    }

    public static class Delegating
    extends PasswordCredentialsProvider {
        private IPasswordCredentialsProvider delegate;

        public Delegating(IPasswordCredentialsProvider delegate) {
            this.delegate = delegate;
        }

        public IPasswordCredentialsProvider getDelegate() {
            return this.delegate;
        }

        public boolean isInteractive() {
            return this.delegate.isInteractive();
        }

        public IPasswordCredentials getCredentials() {
            IPasswordCredentials credentials = super.getCredentials();
            if (credentials == null) {
                credentials = this.delegate.getCredentials();
                this.setCredentials(credentials);
            }
            return credentials;
        }
    }
}

