/*******************************************************************************
 * Copyright (c) 2009, 2012 Atlassian and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Atlassian - initial API and implementation
 ******************************************************************************/

package org.eclipse.mylyn.internal.reviews.ui.annotations;

import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.swt.widgets.Shell;

/**
 * The class that will created the information control for the annotation
 * 
 * @author Shawn Minto
 */
public class CommentInformationControlCreator implements IInformationControlCreator {

	public IInformationControl createInformationControl(Shell parent) {
		return new CommentInformationControl(parent, this);
	}

}