/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.debugmodel;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugTarget;
import org.eclipse.lsp4e.debug.debugmodel.DSPValue;
import org.eclipse.lsp4j.debug.SetVariableArguments;
import org.eclipse.lsp4j.debug.ValueFormat;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;

public class DSPVariable
extends DSPDebugElement
implements IVariable {
    private final Long parentVariablesReference;
    private final String name;
    private DSPValue dspValue;

    public DSPVariable(DSPDebugTarget debugTarget, Long parentVariablesReference, String name, String value, Long childrenVariablesReference) {
        super(debugTarget);
        this.parentVariablesReference = parentVariablesReference;
        this.name = name;
        this.dspValue = new DSPValue(this, childrenVariablesReference, value);
    }

    public void setValue(String expression) throws DebugException {
        SetVariableArguments setVariableArgs = new SetVariableArguments();
        setVariableArgs.setVariablesReference(this.parentVariablesReference);
        setVariableArgs.setValue(expression);
        setVariableArgs.setName(this.getName());
        setVariableArgs.setFormat(new ValueFormat());
        IDebugProtocolServer debugAdapter = this.getDebugProtocolServer();
        debugAdapter.setVariable(setVariableArgs).thenAcceptAsync(res -> {
            String v = res.getValue();
            if (v == null) {
                v = expression;
            }
            this.dspValue = new DSPValue(this, res.getVariablesReference(), v);
            this.fireChangeEvent(512);
        });
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return this.getDebugTarget().getCapabilities().getSupportsSetVariable();
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public IValue getValue() throws DebugException {
        return this.dspValue;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this.name;
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }
}

