/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.modeldata;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.oprofile.core.model.OpModelSample;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.OprofileSAXHandler;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.XMLProcessor;

public class SamplesProcessor
extends XMLProcessor {
    private static final String SAMPLE_TAG = "sample";
    private static final String COUNT_TAG = "count";
    private static final String LINE_TAG = "line";
    private static final String SYMBOL_TAG = "symbol";
    private static final String FILE_TAG = "file";
    private OpModelSample sample;
    private ArrayList<OpModelSample> sampleList;

    @Override
    public void reset(Object callData) {
        this.sample = new OpModelSample();
        this.sampleList = new ArrayList();
    }

    @Override
    public void endElement(String name, Object callData) {
        if (name.equals(COUNT_TAG)) {
            this.sample.setCount(Integer.parseInt(this.characters));
        } else if (name.equals(LINE_TAG)) {
            this.sample.setLine(Integer.parseInt(this.characters));
        } else if (name.equals(FILE_TAG)) {
            this.sample.setFilePath(this.characters);
        } else if (name.equals(SAMPLE_TAG)) {
            this.sampleList.add(this.sample);
            this.sample = new OpModelSample();
        } else if (name.equals(SYMBOL_TAG)) {
            OprofileSAXHandler.getInstance(callData).pop(SYMBOL_TAG);
        }
    }

    public OpModelSample[] getSamples() {
        OpModelSample[] samples = new OpModelSample[this.sampleList.size()];
        this.sampleList.toArray(samples);
        return samples;
    }
}

