/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.views;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.docker.core.IDockerConnection;
import org.eclipse.linuxtools.docker.core.IDockerContainer;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerImageHierarchyContainerNode;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.ui.views.BasePropertySection;
import org.eclipse.linuxtools.internal.docker.ui.views.ContainerInspectContentProvider;
import org.eclipse.linuxtools.internal.docker.ui.views.DVMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ContainerInspectPropertySection
extends BasePropertySection {
    private static final String PropertiesInfoError = "PropertiesInfoError.msg";
    private static final String PropertiesLoadingContainerInfo = "PropertiesLoadingContainerInfo.msg";

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.getTreeViewer().setContentProvider((IContentProvider)new ContainerInspectContentProvider());
    }

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        Object input = this.getSelection(selection);
        IDockerConnection parentConnection = this.getConnection(part, selection);
        IDockerContainerInfo containerInfo = this.getContainerInfo(parentConnection, input);
        if (this.getTreeViewer() != null && containerInfo != null) {
            this.getTreeViewer().setInput((Object)containerInfo);
            this.getTreeViewer().expandAll();
        }
    }

    private IDockerContainerInfo getContainerInfo(IDockerConnection parentConnection, Object input) {
        Assert.isTrue((input instanceof IDockerContainer || input instanceof IDockerImageHierarchyContainerNode ? 1 : 0) != 0);
        if (input instanceof IDockerContainer) {
            return this.getContainerInfo(parentConnection, (IDockerContainer)input);
        }
        return this.getContainerInfo(parentConnection, ((IDockerImageHierarchyContainerNode)input).getElement());
    }

    private IDockerContainerInfo getContainerInfo(final IDockerConnection connection, final IDockerContainer container) {
        final ArrayBlockingQueue result = new ArrayBlockingQueue(1);
        Job loadConnectionInfoJob = new Job(DVMessages.getString(PropertiesLoadingContainerInfo)){

            protected IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(DVMessages.getString(ContainerInspectPropertySection.PropertiesLoadingContainerInfo), 1);
                IDockerContainerInfo containerInfo = connection.getContainerInfo(container.id());
                if (containerInfo != null) {
                    result.add(containerInfo);
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        loadConnectionInfoJob.schedule();
        try {
            return (IDockerContainerInfo)result.poll(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Activator.log((IStatus)new Status(4, "org.eclipse.linuxtools.docker.ui", DVMessages.getFormattedString(PropertiesInfoError, connection.getName()), (Throwable)e));
            return null;
        }
    }
}

