/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.util;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jwt.we.misc.util.internal.gmf.runtime.draw2d.ui.render.awt.internal.svg.export.GraphicsSVG;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;

public class SaveImage {
    public static boolean save(GraphicalViewer viewer, String saveFilePath, int format) {
        if (format != 0 && format != 4 && format != 5) {
            throw new IllegalArgumentException("Save format not supported");
        }
        try {
            SaveImage.saveEditorContentsAsImage(viewer, saveFilePath, format);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean saveSVG(GraphicalViewer viewer, String saveFilePath) {
        try {
            SaveImage.saveEditorContentsAsSVG(viewer, saveFilePath);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void saveEditorContentsAsImage(GraphicalViewer viewer, String saveFilePath, int format) {
        FreeformFigure rootFigure = SaveImage.getRootFigure(viewer);
        Rectangle rootFigureBounds = rootFigure.getFreeformExtent();
        Control figureCanvas = viewer.getControl();
        GC figureCanvasGC = new GC((Drawable)figureCanvas);
        Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
        GC imageGC = new GC((Drawable)img);
        imageGC.setBackground(figureCanvasGC.getBackground());
        imageGC.setForeground(figureCanvasGC.getForeground());
        imageGC.setFont(figureCanvasGC.getFont());
        imageGC.setLineStyle(figureCanvasGC.getLineStyle());
        imageGC.setLineWidth(figureCanvasGC.getLineWidth());
        SWTGraphics imgGraphics = new SWTGraphics(imageGC);
        imgGraphics.translate(rootFigureBounds.getLocation().negate());
        rootFigure.paint((Graphics)imgGraphics);
        ImageData[] imgData = new ImageData[]{img.getImageData()};
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = imgData;
        imgLoader.save(saveFilePath, format);
        figureCanvasGC.dispose();
        imageGC.dispose();
        img.dispose();
    }

    private static void saveEditorContentsAsSVG(GraphicalViewer viewer, String saveFilePath) throws SVGGraphics2DIOException, FileNotFoundException {
        FreeformFigure rootFigure = SaveImage.getRootFigure(viewer);
        Rectangle rootFigureBounds = rootFigure.getFreeformExtent();
        GraphicsSVG graphics = GraphicsSVG.getInstance(rootFigureBounds.getTranslated(rootFigureBounds.getLocation().negate()));
        graphics.translate(rootFigureBounds.getLocation().negate());
        rootFigure.paint((Graphics)graphics);
        graphics.getSVGGraphics2D().stream((Writer)new BufferedWriter(new OutputStreamWriter(new FileOutputStream(saveFilePath))));
    }

    private static FreeformFigure getRootFigure(GraphicalViewer viewer) {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        return (FreeformFigure)rootEditPart.getLayer((Object)"Printable Layers");
    }
}

