/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibraryRegistryFactory;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFVersion;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryEditControl;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationEvent;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryValidationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class JSFLibraryWizard
extends Wizard
implements INewWizard {
    private JSFLibraryEditControl jsfLibraryEditControl;
    private boolean isNew = false;
    private boolean modified = false;
    private JSFLibrary curLibrary;
    private JSFLibrary workingCopyLibrary;
    private JSFLibraryWizardPage page;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        if (selection != null && selection.getFirstElement() instanceof JSFLibrary) {
            this.curLibrary = (JSFLibrary)selection.getFirstElement();
            this.workingCopyLibrary = this.curLibrary.getWorkingCopy();
        } else {
            this.isNew = true;
            this.workingCopyLibrary = JSFLibraryRegistryFactory.eINSTANCE.createJSFLibrary();
        }
        this.setWindowTitle(this.isNew ? Messages.JSFLibraryWizard_CreateJSFLibrary : Messages.JSFLibraryWizard_EditJSFLibrary);
    }

    public boolean performFinish() {
        String originalID;
        String name = this.jsfLibraryEditControl.getJSFLibraryName();
        boolean isDeployed = this.jsfLibraryEditControl.getIsDeployed();
        JSFVersion version = this.jsfLibraryEditControl.getJSFVersion();
        this.workingCopyLibrary.setName(name);
        this.workingCopyLibrary.setDeployed(isDeployed);
        this.workingCopyLibrary.setJSFVersion(version);
        String string = originalID = this.curLibrary != null ? this.curLibrary.getID() : this.workingCopyLibrary.getID();
        if (this.isNew) {
            JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().addJSFLibrary(this.workingCopyLibrary);
        } else {
            this.curLibrary.updateValues(this.workingCopyLibrary);
            try {
                JSFLibraryRegistryUtil.rebindClasspathContainerEntries((String)originalID, (String)this.workingCopyLibrary.getID(), null);
            }
            catch (JavaModelException e) {
                JSFUiPlugin.log(4, "Exception while updating JSF Library containers", e);
            }
        }
        JSFLibraryRegistryUtil.getInstance().saveJSFLibraryRegistry();
        return true;
    }

    public void addPages() {
        this.page = new JSFLibraryWizardPage(Messages.JSFLibraryWizard_JSFLibrary);
        super.addPage((IWizardPage)this.page);
        this.page.setWizard((IWizard)this);
    }

    public JSFLibrary getJSFLibrary() {
        return this.workingCopyLibrary;
    }

    private class JSFLibraryWizardPage
    extends WizardPage {
        protected JSFLibraryWizardPage(String pageName) {
            super(pageName);
            this.setDescription(Messages.JSFLibraryWizard_DESCRIPTION);
            this.setTitle(Messages.JSFLibraryWizard_JSFLibrary);
        }

        public boolean isPageComplete() {
            if (!JSFLibraryWizard.this.modified) {
                return false;
            }
            return super.isPageComplete();
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            JSFLibraryWizard.this.jsfLibraryEditControl = new JSFLibraryEditControl(JSFLibraryWizard.this.workingCopyLibrary, parent);
            JSFLibraryWizard.this.jsfLibraryEditControl.setLayout((Layout)new GridLayout(2, false));
            JSFLibraryWizard.this.jsfLibraryEditControl.setLayoutData(new GridData(1808));
            JSFLibraryWizard.this.jsfLibraryEditControl.addValidationListener(new JSFLibraryValidationListener(){

                public void notifyValidation(JSFLibraryValidationEvent e) {
                    JSFLibraryWizardPage.this.setErrorMessage(e.getMessage());
                    JSFLibraryWizard.this.modified = true;
                    JSFLibraryWizardPage.this.setPageComplete(JSFLibraryWizardPage.this.getErrorMessage() == null);
                }
            });
            this.setControl((Control)JSFLibraryWizard.this.jsfLibraryEditControl);
            this.setPageComplete(false);
        }
    }
}

