/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webservice.wsdd.internal.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.j2ee.common.internal.impl.XMLResourceImpl;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;
import org.eclipse.jst.j2ee.internal.model.translator.webservices.WsddTranslator;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;
import org.eclipse.jst.j2ee.webservice.wsdd.WsddResource;
import org.eclipse.jst.jee.util.internal.JavaEEQuickPeek;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;

public class WsddResourceImpl
extends XMLResourceImpl
implements WsddResource {
    public WsddResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public WsddResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public WebServices getWebServices() {
        return (WebServices)this.getRootObject();
    }

    public Translator getRootTranslator() {
        return WsddTranslator.INSTANCE;
    }

    public int getType() {
        return 6;
    }

    public String getDoctype() {
        switch (this.getJ2EEVersionID()) {
            case 12: 
            case 13: {
                return "webservices";
            }
        }
        return null;
    }

    public boolean isWebService1_0() {
        return this.getModuleVersionID() == 10;
    }

    public boolean isWebService1_1() {
        return this.getModuleVersionID() == 11;
    }

    public boolean isWebService1_2() {
        return this.getModuleVersionID() == 12;
    }

    public boolean isWebService1_3() {
        return this.getModuleVersionID() == 13;
    }

    public boolean isWebService1_4() {
        return this.getModuleVersionID() == 14;
    }

    public void setModuleVersionID(int id) {
        switch (id) {
            case 14: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(14);
                break;
            }
            case 13: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(13);
                break;
            }
            case 12: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(12);
                break;
            }
            case 11: {
                super.setDoctypeValues(null, null);
                this.primSetVersionID(11);
                break;
            }
            case 10: {
                super.setDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
            }
        }
    }

    public void setJ2EEVersionID(int id) {
        switch (id) {
            case 70: 
            case 80: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(14);
                break;
            }
            case 60: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(13);
                break;
            }
            case 50: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(12);
                break;
            }
            case 14: {
                this.primSetDoctypeValues(null, null);
                this.primSetVersionID(11);
                break;
            }
            case 13: {
                this.primSetDoctypeValues(this.getJ2EE_1_3_PublicID(), this.getJ2EE_1_3_SystemID());
                this.primSetVersionID(10);
                break;
            }
            case 12: {
                this.primSetDoctypeValues(this.getJ2EE_1_2_PublicID(), this.getJ2EE_1_2_SystemID());
                this.primSetVersionID(10);
            }
        }
    }

    public String getJ2EE_1_2_PublicID() {
        return "-//IBM Corporation, Inc.//DTD J2EE Web services 1.0//EN";
    }

    public String getJ2EE_1_2_SystemID() {
        return "http://www.ibm.com/webservices/dtd/j2ee_web_services_1_0.dtd";
    }

    public String getJ2EE_1_3_PublicID() {
        return "-//IBM Corporation, Inc.//DTD J2EE Web services 1.0//EN";
    }

    public String getJ2EE_1_3_SystemID() {
        return "http://www.ibm.com/webservices/dtd/j2ee_web_services_1_0.dtd";
    }

    public int getJ2EEVersionID() {
        switch (this.getModuleVersionID()) {
            case 10: {
                return 13;
            }
            case 11: {
                return 14;
            }
            case 12: {
                return 50;
            }
            case 13: {
                return 60;
            }
            case 14: {
                return 70;
            }
        }
        return 70;
    }

    protected int getDefaultVersionID() {
        return 10;
    }

    protected void syncVersionOfRootObject() {
    }

    public void setDoctypeValues(String publicId, String systemId) {
        int myVersion = 14;
        if (systemId == null) {
            myVersion = this.primGetVersionID();
            this.setModuleVersionID(myVersion);
            return;
        }
        super.setDoctypeValues(publicId, systemId);
    }

    private int primGetVersionID() {
        IFile afile = WorkbenchResourceHelper.getFile((ReferencedResource)this);
        InputStream in = null;
        JavaEEQuickPeek quickPeek = null;
        if (afile != null && afile.exists()) {
            try {
                in = afile.getContents();
                quickPeek = new JavaEEQuickPeek(in);
                return quickPeek.getVersion();
            }
            catch (CoreException e) {
                J2EECorePlugin.logError(e);
            }
        } else {
            String path = this.getURI().toFileString();
            if (path != null) {
                try {
                    in = new FileInputStream(path);
                    quickPeek = new JavaEEQuickPeek(in);
                    int n = quickPeek.getVersion();
                    return n;
                }
                catch (FileNotFoundException e1) {
                    J2EECorePlugin.logError(e1);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {
                            J2EECorePlugin.logError(e);
                        }
                    }
                }
            }
        }
        return this.getModuleVersionID();
    }
}

