/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.webservice.internal.util;

import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.CommonPackage;
import org.eclipse.jst.j2ee.common.Description;
import org.eclipse.jst.j2ee.common.DisplayName;
import org.eclipse.jst.j2ee.common.IconType;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.jst.j2ee.webservice.internal.util.DescriptionGroupItem;
import org.eclipse.jst.j2ee.webservice.wscommon.DescriptionType;
import org.eclipse.jst.j2ee.webservice.wscommon.DisplayNameType;
import org.eclipse.jst.j2ee.webservice.wscommon.WscommonFactory;
import org.eclipse.jst.j2ee.webservice.wscommon.WscommonPackage;
import org.eclipse.jst.j2ee.webservice.wsdd.Handler;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServiceDescription;
import org.eclipse.jst.j2ee.webservice.wsdd.WebServices;

public class DescriptionGroupHelper {
    public static String[] getValues(WebServices webServices, DescriptionGroupItem item) {
        return DescriptionGroupHelper.getValues(webServices, item, false);
    }

    public static String[] getValues(WebServices webServices, DescriptionGroupItem item, boolean getLang) {
        J2EEVersionResource res = (J2EEVersionResource)webServices.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                return DescriptionGroupHelper.getDescriptions(webServices, isJ2EE14, getLang);
            }
            case 1: {
                return DescriptionGroupHelper.getDisplayNames(webServices, isJ2EE14, getLang);
            }
            case 2: {
                return DescriptionGroupHelper.getSmallIcons(webServices, isJ2EE14, getLang);
            }
            case 3: {
                return DescriptionGroupHelper.getLargeIcons(webServices, isJ2EE14, getLang);
            }
        }
        return null;
    }

    private static String[] getDescriptions(WebServices webServices, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] descriptions = webServices.getDescriptions().toArray();
            values = new String[descriptions.length];
            if (lang) {
                int i = 0;
                while (i < descriptions.length) {
                    values[i] = ((Description)descriptions[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < descriptions.length) {
                    values[i] = ((Description)descriptions[i]).getValue();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : webServices.getDescription()};
        }
        return values;
    }

    private static String[] getDisplayNames(WebServices webServices, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] displayNames = webServices.getDisplayNames().toArray();
            values = new String[displayNames.length];
            if (lang) {
                int i = 0;
                while (i < displayNames.length) {
                    values[i] = ((DisplayName)displayNames[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < displayNames.length) {
                    values[i] = ((DisplayName)displayNames[i]).getValue();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : webServices.getDisplayName()};
        }
        return values;
    }

    private static String[] getSmallIcons(WebServices webServices, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] icons = webServices.getIcons().toArray();
            values = new String[icons.length];
            if (lang) {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getSmallIcon();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : webServices.getSmallIcon()};
        }
        return values;
    }

    private static String[] getLargeIcons(WebServices webServices, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] icons = webServices.getIcons().toArray();
            values = new String[icons.length];
            if (lang) {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLargeIcon();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : webServices.getLargeIcon()};
        }
        return values;
    }

    public static String getValue(WebServiceDescription webServicesDescription, DescriptionGroupItem item) {
        return DescriptionGroupHelper.getValue(webServicesDescription, item, false);
    }

    public static String getValue(WebServiceDescription webServicesDescription, DescriptionGroupItem item, boolean getLang) {
        J2EEVersionResource res = (J2EEVersionResource)webServicesDescription.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                return DescriptionGroupHelper.getDescription(webServicesDescription, isJ2EE14, getLang);
            }
            case 1: {
                return DescriptionGroupHelper.getDisplayName(webServicesDescription, isJ2EE14, getLang);
            }
            case 2: {
                return DescriptionGroupHelper.getSmallIcon(webServicesDescription, isJ2EE14, getLang);
            }
            case 3: {
                return DescriptionGroupHelper.getLargeIcon(webServicesDescription, isJ2EE14, getLang);
            }
        }
        return null;
    }

    private static String getDescription(WebServiceDescription webServicesDescription, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            DescriptionType descType = webServicesDescription.getDescriptionType();
            if (descType != null) {
                ret = lang ? descType.getLang() : descType.getValue();
            }
        } else if (!lang) {
            ret = webServicesDescription.getDescription();
        }
        return ret;
    }

    private static String getDisplayName(WebServiceDescription webServicesDescription, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            DisplayNameType dnType = webServicesDescription.getDisplayNameType();
            if (dnType != null) {
                ret = lang ? dnType.getLang() : dnType.getValue();
            }
        } else if (!lang) {
            ret = webServicesDescription.getDisplayName();
        }
        return ret;
    }

    private static String getSmallIcon(WebServiceDescription webServicesDescription, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            IconType iconType = webServicesDescription.getIconType();
            if (iconType != null) {
                ret = lang ? iconType.getLang() : iconType.getSmallIcon();
            }
        } else if (!lang) {
            ret = webServicesDescription.getSmallIcon();
        }
        return ret;
    }

    private static String getLargeIcon(WebServiceDescription webServicesDescription, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            IconType iconType = webServicesDescription.getIconType();
            if (iconType != null) {
                ret = lang ? iconType.getLang() : iconType.getLargeIcon();
            }
        } else if (!lang) {
            ret = webServicesDescription.getLargeIcon();
        }
        return ret;
    }

    public static String getValue(PortComponent portComponent, DescriptionGroupItem item) {
        return DescriptionGroupHelper.getValue(portComponent, item, false);
    }

    public static String getValue(PortComponent portComponent, DescriptionGroupItem item, boolean getLang) {
        J2EEVersionResource res = (J2EEVersionResource)portComponent.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                return DescriptionGroupHelper.getDescription(portComponent, isJ2EE14, getLang);
            }
            case 1: {
                return DescriptionGroupHelper.getDisplayName(portComponent, isJ2EE14, getLang);
            }
            case 2: {
                return DescriptionGroupHelper.getSmallIcon(portComponent, isJ2EE14, getLang);
            }
            case 3: {
                return DescriptionGroupHelper.getLargeIcon(portComponent, isJ2EE14, getLang);
            }
        }
        return null;
    }

    private static String getDescription(PortComponent portComponent, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            DescriptionType descType = portComponent.getDescriptionType();
            if (descType != null) {
                ret = lang ? descType.getLang() : descType.getValue();
            }
        } else if (!lang) {
            ret = portComponent.getDescription();
        }
        return ret;
    }

    private static String getDisplayName(PortComponent portComponent, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            DisplayNameType dnType = portComponent.getDisplayNameType();
            if (dnType != null) {
                ret = lang ? dnType.getLang() : dnType.getValue();
            }
        } else if (!lang) {
            ret = portComponent.getDisplayName();
        }
        return ret;
    }

    private static String getSmallIcon(PortComponent portComponent, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            IconType iconType = portComponent.getIconType();
            if (iconType != null) {
                ret = lang ? iconType.getLang() : iconType.getSmallIcon();
            }
        } else if (!lang) {
            ret = portComponent.getSmallIcon();
        }
        return ret;
    }

    private static String getLargeIcon(PortComponent portComponent, boolean isJ2EE14, boolean lang) {
        String ret = null;
        if (isJ2EE14) {
            IconType iconType = portComponent.getIconType();
            if (iconType != null) {
                ret = lang ? iconType.getLang() : iconType.getLargeIcon();
            }
        } else if (!lang) {
            ret = portComponent.getLargeIcon();
        }
        return ret;
    }

    public static String[] getValues(Handler handler, DescriptionGroupItem item) {
        return DescriptionGroupHelper.getValues(handler, item, false);
    }

    public static String[] getValues(Handler handler, DescriptionGroupItem item, boolean getLang) {
        J2EEVersionResource res = (J2EEVersionResource)handler.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                return DescriptionGroupHelper.getDescriptions(handler, isJ2EE14, getLang);
            }
            case 1: {
                return DescriptionGroupHelper.getDisplayNames(handler, isJ2EE14, getLang);
            }
            case 2: {
                return DescriptionGroupHelper.getSmallIcons(handler, isJ2EE14, getLang);
            }
            case 3: {
                return DescriptionGroupHelper.getLargeIcons(handler, isJ2EE14, getLang);
            }
        }
        return null;
    }

    private static String[] getDescriptions(Handler handler, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] descriptions = handler.getDescriptions().toArray();
            values = new String[descriptions.length];
            if (lang) {
                int i = 0;
                while (i < descriptions.length) {
                    values[i] = ((Description)descriptions[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < descriptions.length) {
                    values[i] = ((Description)descriptions[i]).getValue();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : handler.getDescription()};
        }
        return values;
    }

    private static String[] getDisplayNames(Handler handler, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] displayNames = handler.getDisplayNames().toArray();
            values = new String[displayNames.length];
            if (lang) {
                int i = 0;
                while (i < displayNames.length) {
                    values[i] = ((DisplayName)displayNames[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < displayNames.length) {
                    values[i] = ((DisplayName)displayNames[i]).getValue();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : handler.getDisplayName()};
        }
        return values;
    }

    private static String[] getSmallIcons(Handler handler, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] icons = handler.getIcons().toArray();
            values = new String[icons.length];
            if (lang) {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getSmallIcon();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : handler.getSmallIcon()};
        }
        return values;
    }

    private static String[] getLargeIcons(Handler handler, boolean isJ2EE14, boolean lang) {
        String[] values = null;
        if (isJ2EE14) {
            Object[] icons = handler.getIcons().toArray();
            values = new String[icons.length];
            if (lang) {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLang();
                    ++i;
                }
            } else {
                int i = 0;
                while (i < icons.length) {
                    values[i] = ((IconType)icons[i]).getLargeIcon();
                    ++i;
                }
            }
        } else {
            values = new String[]{lang ? null : handler.getLargeIcon()};
        }
        return values;
    }

    public static void setValue(WebServices webServices, DescriptionGroupItem item, String value) {
        DescriptionGroupHelper.setValue(webServices, item, value, false);
    }

    public static void setValue(WebServices webServices, DescriptionGroupItem item, String value, boolean setLang) {
        J2EEVersionResource res = (J2EEVersionResource)webServices.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                DescriptionGroupHelper.setDescription(webServices, isJ2EE14, value, setLang);
            }
            case 1: {
                DescriptionGroupHelper.setDisplayName(webServices, isJ2EE14, value, setLang);
            }
            case 2: {
                DescriptionGroupHelper.setSmallIcon(webServices, isJ2EE14, value, setLang);
            }
            case 3: {
                DescriptionGroupHelper.setLargeIcon(webServices, isJ2EE14, value, setLang);
            }
        }
    }

    private static void setDescription(WebServices webServices, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] descriptions = webServices.getDescriptions().toArray();
            Description firstDescription = null;
            if (descriptions.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                Description newDescription = factory.createDescription();
                if (setLang) {
                    newDescription.setLang(value);
                } else {
                    newDescription.setValue(value);
                }
                webServices.getDescriptions().add((Object)newDescription);
            } else {
                firstDescription = (Description)descriptions[0];
                if (setLang) {
                    firstDescription.setLang(value);
                } else {
                    firstDescription.setValue(value);
                }
            }
        } else if (!setLang) {
            webServices.setDescription(value);
        }
    }

    private static void setDisplayName(WebServices webServices, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] displayNames = webServices.getDisplayNames().toArray();
            DisplayName firstDisplayName = null;
            if (displayNames.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                DisplayName newDisplayName = factory.createDisplayName();
                if (setLang) {
                    newDisplayName.setLang(value);
                } else {
                    newDisplayName.setValue(value);
                }
                webServices.getDisplayNames().add((Object)newDisplayName);
            } else {
                firstDisplayName = (DisplayName)displayNames[0];
                if (setLang) {
                    firstDisplayName.setLang(value);
                } else {
                    firstDisplayName.setValue(value);
                }
            }
        } else if (!setLang) {
            webServices.setDisplayName(value);
        }
    }

    private static void setSmallIcon(WebServices webServices, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] icons = webServices.getIcons().toArray();
            IconType firstIcon = null;
            if (icons.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType newIcon = factory.createIconType();
                if (setLang) {
                    newIcon.setLang(value);
                } else {
                    newIcon.setSmallIcon(value);
                }
                webServices.getIcons().add((Object)newIcon);
            } else {
                firstIcon = (IconType)icons[0];
                if (setLang) {
                    firstIcon.setLang(value);
                } else {
                    firstIcon.setSmallIcon(value);
                }
            }
        } else if (!setLang) {
            webServices.setSmallIcon(value);
        }
    }

    private static void setLargeIcon(WebServices webServices, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] icons = webServices.getIcons().toArray();
            IconType firstIcon = null;
            if (icons.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType newIcon = factory.createIconType();
                if (setLang) {
                    newIcon.setLang(value);
                } else {
                    newIcon.setLargeIcon(value);
                }
                webServices.getIcons().add((Object)newIcon);
            } else {
                firstIcon = (IconType)icons[0];
                if (setLang) {
                    firstIcon.setLang(value);
                } else {
                    firstIcon.setLargeIcon(value);
                }
            }
        } else if (!setLang) {
            webServices.setLargeIcon(value);
        }
    }

    public static void setValue(WebServiceDescription webServiceDescription, DescriptionGroupItem item, String value) {
        DescriptionGroupHelper.setValue(webServiceDescription, item, value, false);
    }

    public static void setValue(WebServiceDescription webServiceDescription, DescriptionGroupItem item, String value, boolean setLang) {
        J2EEVersionResource res = (J2EEVersionResource)webServiceDescription.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                DescriptionGroupHelper.setDescription(webServiceDescription, isJ2EE14, value, setLang);
            }
            case 1: {
                DescriptionGroupHelper.setDisplayName(webServiceDescription, isJ2EE14, value, setLang);
            }
            case 2: {
                DescriptionGroupHelper.setSmallIcon(webServiceDescription, isJ2EE14, value, setLang);
            }
            case 3: {
                DescriptionGroupHelper.setLargeIcon(webServiceDescription, isJ2EE14, value, setLang);
            }
        }
    }

    private static void setDescription(WebServiceDescription webServiceDescription, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            DescriptionType description = webServiceDescription.getDescriptionType();
            if (description == null) {
                WscommonFactory factory = WscommonPackage.eINSTANCE.getWscommonFactory();
                DescriptionType descriptionNew = factory.createDescriptionType();
                if (setLang) {
                    descriptionNew.setLang(value);
                } else {
                    descriptionNew.setValue(value);
                }
                webServiceDescription.setDescriptionType(descriptionNew);
            } else if (setLang) {
                description.setLang(value);
            } else {
                description.setValue(value);
            }
        } else if (!setLang) {
            webServiceDescription.setDescription(value);
        }
    }

    private static void setDisplayName(WebServiceDescription webServiceDescription, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            DisplayNameType displayName = webServiceDescription.getDisplayNameType();
            if (displayName == null) {
                WscommonFactory factory = WscommonPackage.eINSTANCE.getWscommonFactory();
                DisplayNameType displayNameNew = factory.createDisplayNameType();
                if (setLang) {
                    displayNameNew.setLang(value);
                } else {
                    displayNameNew.setValue(value);
                }
                webServiceDescription.setDisplayNameType(displayNameNew);
            } else if (setLang) {
                displayName.setLang(value);
            } else {
                displayName.setValue(value);
            }
        } else if (!setLang) {
            webServiceDescription.setDisplayName(value);
        }
    }

    private static void setSmallIcon(WebServiceDescription webServiceDescription, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            IconType icon = webServiceDescription.getIconType();
            if (icon == null) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType iconNew = factory.createIconType();
                if (setLang) {
                    iconNew.setLang(value);
                } else {
                    iconNew.setSmallIcon(value);
                }
                webServiceDescription.setIconType(iconNew);
            } else if (setLang) {
                icon.setLang(value);
            } else {
                icon.setSmallIcon(value);
            }
        } else if (!setLang) {
            webServiceDescription.setSmallIcon(value);
        }
    }

    private static void setLargeIcon(WebServiceDescription webServiceDescription, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            IconType icon = webServiceDescription.getIconType();
            if (icon == null) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType iconNew = factory.createIconType();
                if (setLang) {
                    iconNew.setLang(value);
                } else {
                    iconNew.setLargeIcon(value);
                }
                webServiceDescription.setIconType(iconNew);
            } else if (setLang) {
                icon.setLang(value);
            } else {
                icon.setLargeIcon(value);
            }
        } else if (!setLang) {
            webServiceDescription.setLargeIcon(value);
        }
    }

    public static void setValue(PortComponent portComponent, DescriptionGroupItem item, String value) {
        DescriptionGroupHelper.setValue(portComponent, item, value, false);
    }

    public static void setValue(PortComponent portComponent, DescriptionGroupItem item, String value, boolean setLang) {
        J2EEVersionResource res = (J2EEVersionResource)portComponent.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                DescriptionGroupHelper.setDescription(portComponent, isJ2EE14, value, setLang);
            }
            case 1: {
                DescriptionGroupHelper.setDisplayName(portComponent, isJ2EE14, value, setLang);
            }
            case 2: {
                DescriptionGroupHelper.setSmallIcon(portComponent, isJ2EE14, value, setLang);
            }
            case 3: {
                DescriptionGroupHelper.setLargeIcon(portComponent, isJ2EE14, value, setLang);
            }
        }
    }

    private static void setDescription(PortComponent portComponent, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            DescriptionType description = portComponent.getDescriptionType();
            if (description == null) {
                WscommonFactory factory = WscommonPackage.eINSTANCE.getWscommonFactory();
                DescriptionType descriptionNew = factory.createDescriptionType();
                if (setLang) {
                    descriptionNew.setLang(value);
                } else {
                    descriptionNew.setValue(value);
                }
                portComponent.setDescriptionType(descriptionNew);
            } else if (setLang) {
                description.setLang(value);
            } else {
                description.setValue(value);
            }
        } else if (!setLang) {
            portComponent.setDescription(value);
        }
    }

    private static void setDisplayName(PortComponent portComponent, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            DisplayNameType displayName = portComponent.getDisplayNameType();
            if (displayName == null) {
                WscommonFactory factory = WscommonPackage.eINSTANCE.getWscommonFactory();
                DisplayNameType displayNameNew = factory.createDisplayNameType();
                if (setLang) {
                    displayNameNew.setLang(value);
                } else {
                    displayNameNew.setValue(value);
                }
                portComponent.setDisplayNameType(displayNameNew);
            } else if (setLang) {
                displayName.setLang(value);
            } else {
                displayName.setValue(value);
            }
        } else if (!setLang) {
            portComponent.setDisplayName(value);
        }
    }

    private static void setSmallIcon(PortComponent portComponent, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            IconType icon = portComponent.getIconType();
            if (icon == null) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType iconNew = factory.createIconType();
                if (setLang) {
                    iconNew.setLang(value);
                } else {
                    iconNew.setSmallIcon(value);
                }
                portComponent.setIconType(iconNew);
            } else if (setLang) {
                icon.setLang(value);
            } else {
                icon.setSmallIcon(value);
            }
        } else if (!setLang) {
            portComponent.setSmallIcon(value);
        }
    }

    private static void setLargeIcon(PortComponent portComponent, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            IconType icon = portComponent.getIconType();
            if (icon == null) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType iconNew = factory.createIconType();
                if (setLang) {
                    iconNew.setLang(value);
                } else {
                    iconNew.setLargeIcon(value);
                }
                portComponent.setIconType(iconNew);
            } else if (setLang) {
                icon.setLang(value);
            } else {
                icon.setLargeIcon(value);
            }
        } else if (!setLang) {
            portComponent.setLargeIcon(value);
        }
    }

    public static void setValue(Handler handler, DescriptionGroupItem item, String value) {
        DescriptionGroupHelper.setValue(handler, item, value, false);
    }

    public static void setValue(Handler handler, DescriptionGroupItem item, String value, boolean setLang) {
        J2EEVersionResource res = (J2EEVersionResource)handler.eResource();
        boolean isJ2EE14 = false;
        if (res.getJ2EEVersionID() == 14) {
            isJ2EE14 = true;
        }
        switch (item.getValue()) {
            case 0: {
                DescriptionGroupHelper.setDescription(handler, isJ2EE14, value, setLang);
            }
            case 1: {
                DescriptionGroupHelper.setDisplayName(handler, isJ2EE14, value, setLang);
            }
            case 2: {
                DescriptionGroupHelper.setSmallIcon(handler, isJ2EE14, value, setLang);
            }
            case 3: {
                DescriptionGroupHelper.setLargeIcon(handler, isJ2EE14, value, setLang);
            }
        }
    }

    private static void setDescription(Handler handler, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] descriptions = handler.getDescriptions().toArray();
            Description firstDescription = null;
            if (descriptions.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                Description newDescription = factory.createDescription();
                if (setLang) {
                    newDescription.setLang(value);
                } else {
                    newDescription.setValue(value);
                }
                handler.getDescriptions().add((Object)newDescription);
            } else {
                firstDescription = (Description)descriptions[0];
                if (setLang) {
                    firstDescription.setLang(value);
                } else {
                    firstDescription.setValue(value);
                }
            }
        } else if (!setLang) {
            handler.setDescription(value);
        }
    }

    private static void setDisplayName(Handler handler, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] displayNames = handler.getDisplayNames().toArray();
            DisplayName firstDisplayName = null;
            if (displayNames.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                DisplayName newDisplayName = factory.createDisplayName();
                if (setLang) {
                    newDisplayName.setLang(value);
                } else {
                    newDisplayName.setValue(value);
                }
                handler.getDisplayNames().add((Object)newDisplayName);
            } else {
                firstDisplayName = (DisplayName)displayNames[0];
                if (setLang) {
                    firstDisplayName.setLang(value);
                } else {
                    firstDisplayName.setValue(value);
                }
            }
        } else if (!setLang) {
            handler.setDisplayName(value);
        }
    }

    private static void setSmallIcon(Handler handler, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] icons = handler.getIcons().toArray();
            IconType firstIcon = null;
            if (icons.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType newIcon = factory.createIconType();
                if (setLang) {
                    newIcon.setLang(value);
                } else {
                    newIcon.setSmallIcon(value);
                }
                handler.getIcons().add((Object)newIcon);
            } else {
                firstIcon = (IconType)icons[0];
                if (setLang) {
                    firstIcon.setLang(value);
                } else {
                    firstIcon.setSmallIcon(value);
                }
            }
        } else if (!setLang) {
            handler.setSmallIcon(value);
        }
    }

    private static void setLargeIcon(Handler handler, boolean isJ2EE14, String value, boolean setLang) {
        if (isJ2EE14) {
            Object[] icons = handler.getIcons().toArray();
            IconType firstIcon = null;
            if (icons.length < 1) {
                CommonFactory factory = CommonPackage.eINSTANCE.getCommonFactory();
                IconType newIcon = factory.createIconType();
                if (setLang) {
                    newIcon.setLang(value);
                } else {
                    newIcon.setLargeIcon(value);
                }
                handler.getIcons().add((Object)newIcon);
            } else {
                firstIcon = (IconType)icons[0];
                if (setLang) {
                    firstIcon.setLang(value);
                } else {
                    firstIcon.setLargeIcon(value);
                }
            }
        } else if (!setLang) {
            handler.setLargeIcon(value);
        }
    }
}

