/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.Set;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.CreateManyToManyRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.ICreateBiDirRelationFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.i18n.JPAEditorMessages;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.HasReferanceRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyBiDirRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class CreateManyToManyBiDirRelationFeature
extends CreateManyToManyRelationFeature
implements ICreateBiDirRelationFeature {
    public CreateManyToManyBiDirRelationFeature(IJPAEditorFeatureProvider fp) {
        super(fp, JPAEditorMessages.CreateManyToManyBiDirRelationFeature_manyToManyBiDirFeatureName, JPAEditorMessages.CreateManyToManyBiDirRelationFeature_manyToManyUniDirFeatureDescription);
    }

    @Override
    public ManyToManyBiDirRelation createRelation(IJPAEditorFeatureProvider fp, PictogramElement source, PictogramElement target, PersistentType embeddingEntity) {
        String inverseAttributeName;
        String ownerAttributeName;
        PersistentType owner = (PersistentType)this.getBusinessObjectForPictogramElement(source);
        PersistentType inverse = (PersistentType)this.getBusinessObjectForPictogramElement(target);
        String nameWithNonCapitalLetter = ownerAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(inverse));
        if (JpaArtifactFactory.instance().isMethodAnnotated(owner)) {
            nameWithNonCapitalLetter = JPAEditorUtil.produceValidAttributeName(ownerAttributeName);
        }
        String ownerAttributeText = JPAEditorUtil.produceUniqueAttributeName(owner, nameWithNonCapitalLetter);
        String nameWithNonCapitalLetter2 = inverseAttributeName = JPAEditorUtil.returnSimpleName(JpaArtifactFactory.instance().getEntityName(owner));
        if (JpaArtifactFactory.instance().isMethodAnnotated(inverse)) {
            nameWithNonCapitalLetter2 = JPAEditorUtil.produceValidAttributeName(inverseAttributeName);
        }
        String inverseAttributeText = JPAEditorUtil.produceUniqueAttributeName(inverse, ownerAttributeText, nameWithNonCapitalLetter2);
        ManyToManyBiDirRelation rel = new ManyToManyBiDirRelation(fp, owner, inverse, ownerAttributeText, inverseAttributeText, true, embeddingEntity);
        return rel;
    }

    public String getCreateImageId() {
        return "org.eclipse.jpt.jpadiagrameditor.ui.many_to_many_2_dir_relation";
    }

    @Override
    protected boolean isRelationshipPossible() {
        if (JpaArtifactFactory.instance().isEmbeddable(this.owner)) {
            Set<HasReferanceRelation> refs = JpaArtifactFactory.instance().findAllHasReferenceRelsByEmbeddableWithEntity(this.owner, this.getFeatureProvider());
            if (refs.size() != 1) {
                return false;
            }
            for (HasReferanceRelation ref : refs) {
                AttributeMapping attributeMapping = JpaArtifactFactory.instance().getAttributeMapping(ref.getEmbeddedAnnotatedAttribute());
                if (!(attributeMapping instanceof ElementCollectionMapping2_0) && !(attributeMapping instanceof EmbeddedIdMapping)) continue;
                return false;
            }
        }
        return true;
    }
}

