/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;

public final class RefactoringAvailabilityTesterCore {
    public static boolean isMoveStaticMembersAvailable(IMember[] members) throws JavaModelException {
        if (members == null) {
            return false;
        }
        if (members.length == 0) {
            return false;
        }
        if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(members)) {
            return false;
        }
        return RefactoringAvailabilityTesterCore.isCommonDeclaringType(members);
    }

    public static boolean isMoveStaticAvailable(IMember[] members) throws JavaModelException {
        int index = 0;
        while (index < members.length) {
            if (!RefactoringAvailabilityTesterCore.isMoveStaticAvailable(members[index])) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isMoveStaticAvailable(IMember member) throws JavaModelException {
        boolean is18OrHigher;
        if (!member.exists()) {
            return false;
        }
        int type = member.getElementType();
        if (type != 9 && type != 8 && type != 7) {
            return false;
        }
        if (JdtFlags.isEnum(member) && type != 7) {
            return false;
        }
        IType declaring = member.getDeclaringType();
        if (declaring == null) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)member)) {
            return false;
        }
        if (!(type != 9 || !declaring.isInterface() || (is18OrHigher = JavaModelUtil.is18OrHigher(member.getJavaProject())) && Flags.isStatic((int)member.getFlags()))) {
            return false;
        }
        if (type == 9 && !JdtFlags.isStatic(member)) {
            return false;
        }
        if (type == 9 && ((IMethod)member).isConstructor()) {
            return false;
        }
        if (type == 7 && !JdtFlags.isStatic(member)) {
            return false;
        }
        return declaring.isInterface() || JdtFlags.isStatic(member);
    }

    public static boolean isCommonDeclaringType(IMember[] members) {
        if (members.length == 0) {
            return false;
        }
        IType type = members[0].getDeclaringType();
        if (type == null) {
            return false;
        }
        int index = 0;
        while (index < members.length) {
            if (!type.equals(members[index].getDeclaringType())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static boolean isDelegateCreationAvailable(IField field) throws JavaModelException {
        return field.exists() && Flags.isStatic((int)field.getFlags()) && Flags.isFinal((int)field.getFlags());
    }
}

