/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe2.ecore;

import com.google.common.base.Function;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.codegen.ecore.generator.GeneratorAdapterFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.generator.GenModelGeneratorAdapter;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.util.ImportManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.mwe.utils.GenModelHelper;
import org.eclipse.emf.mwe2.ecore.CvsIdFilteringGeneratorAdapterFactoryDescriptor;
import org.eclipse.emf.mwe2.runtime.Mandatory;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowComponent;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;

public class EcoreGenerator
implements IWorkflowComponent {
    private static Logger log = Logger.getLogger(EcoreGenerator.class);
    private boolean generateEdit = false;
    private boolean generateEditor = false;
    private boolean generateCustomClasses = false;
    private String lineDelimiter = System.getProperty("line.separator");
    protected List<String> srcPaths = new ArrayList<String>();
    private String genModel;
    private ResourceSet resourceSet;

    static {
        EcorePackage.eINSTANCE.getEFactoryInstance();
        GenModelPackage.eINSTANCE.getEFactoryInstance();
    }

    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    public void setGenerateEdit(boolean generateEdit) {
        this.generateEdit = generateEdit;
    }

    public void setGenerateEditor(boolean generateEditor) {
        this.generateEditor = generateEditor;
    }

    public void setGenerateCustomClasses(boolean generateCustomClasses) {
        this.generateCustomClasses = generateCustomClasses;
    }

    @Mandatory
    public void addSrcPath(String srcPath) {
        this.srcPaths.add(srcPath);
    }

    @Mandatory
    public void setGenModel(String genModel) {
        this.genModel = genModel;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public void preInvoke() {
        this.getResourceSet().getResource(URI.createURI((String)this.genModel), true);
    }

    public void postInvoke() {
    }

    protected GenModelHelper createGenModelSetup() {
        return new GenModelHelper();
    }

    public void invoke(IWorkflowContext ctx) {
        Diagnostic editorDiag;
        Diagnostic editDiag;
        ResourceSet resSet = this.getResourceSet();
        Resource resource = resSet.getResource(URI.createURI((String)this.genModel), true);
        GenModel genModel = (GenModel)resource.getContents().get(0);
        genModel.setCanGenerate(true);
        genModel.reconcile();
        this.createGenModelSetup().registerGenModel(genModel);
        Generator generator = new Generator(){

            public JControlModel getJControlModel() {
                return new JControlModel(){

                    public boolean canMerge() {
                        return false;
                    }
                };
            }
        };
        log.info((Object)("generating EMF code for " + this.genModel));
        generator.getAdapterFactoryDescriptorRegistry().addDescriptor("http://www.eclipse.org/emf/2002/GenModel", (GeneratorAdapterFactory.Descriptor)new GeneratorAdapterDescriptor(this.getTypeMapper(), this.getLineDelimiter()));
        generator.setInput((Object)genModel);
        Diagnostic diagnostic = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", (Monitor)new BasicMonitor());
        if (diagnostic.getSeverity() != 0) {
            log.info((Object)diagnostic);
        }
        if (this.generateEdit && (editDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editDiag);
        }
        if (this.generateEditor && (editorDiag = generator.generate((Object)genModel, (Object)"org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", (Monitor)new BasicMonitor())).getSeverity() != 0) {
            log.info((Object)editorDiag);
        }
    }

    private ResourceSet getResourceSet() {
        return this.resourceSet == null ? new ResourceSetImpl() : this.resourceSet;
    }

    protected Function<String, String> getTypeMapper() {
        return new mapper();
    }

    public void generate(String from, String customClassName, URI path) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.copyright()).append("\n");
        int lastIndexOfDot = customClassName.lastIndexOf(46);
        sb.append("package ").append(customClassName.substring(0, lastIndexOfDot)).append(";\n\n\n");
        sb.append("public class ").append(customClassName.substring(lastIndexOfDot + 1)).append(" extends ").append(from).append(" {\n\n");
        sb.append("}\n");
        try {
            OutputStream stream = URIConverter.INSTANCE.createOutputStream(path);
            stream.write(sb.toString().getBytes());
            stream.close();
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
    }

    protected String copyright() {
        return "/*******************************************************************************\n* Copyright (c) 2008 - 2010 itemis AG (http://www.itemis.eu) and others.\n* All rights reserved. This program and the accompanying materials\n* are made available under the terms of the Eclipse Public License v1.0\n* which accompanies this distribution, and is available at\n* http://www.eclipse.org/legal/epl-v10.html\n*******************************************************************************/";
    }

    protected static class GeneratorAdapterDescriptor
    extends CvsIdFilteringGeneratorAdapterFactoryDescriptor {
        private Function<String, String> typeMapper;

        protected GeneratorAdapterDescriptor(Function<String, String> typeMapper) {
            this.typeMapper = typeMapper;
        }

        public GeneratorAdapterDescriptor(Function<String, String> typeMapper, String lineDelimiter) {
            super(lineDelimiter);
            this.typeMapper = typeMapper;
        }

        @Override
        public GeneratorAdapterFactory createAdapterFactory() {
            return new CustomImplAwareGeneratorAdapterFactory();
        }

        private final class CustomImplAwareGeneratorAdapterFactory
        extends CvsIdFilteringGeneratorAdapterFactoryDescriptor.IdFilteringGenModelGeneratorAdapterFactory {
            private CustomImplAwareGeneratorAdapterFactory() {
                super(GeneratorAdapterDescriptor.this);
            }

            @Override
            public Adapter createGenClassAdapter() {
                return new CvsIdFilteringGeneratorAdapterFactoryDescriptor.IdFilteringGenModelGeneratorAdapterFactory.IdFilteringGenClassAdapter(this, (GeneratorAdapterFactory)this){

                    @Override
                    protected void createImportManager(String packageName, String className) {
                        this.importManager = new ImportManagerHack(packageName, (Function<String, String>)GeneratorAdapterDescriptor.this.typeMapper);
                        this.importManager.addMasterImport(packageName, className);
                        if (this.generatingObject != null) {
                            ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
                        }
                    }
                };
            }

            @Override
            public Adapter createGenEnumAdapter() {
                return new CvsIdFilteringGeneratorAdapterFactoryDescriptor.IdFilteringGenModelGeneratorAdapterFactory.IdFilteringGenEnumAdapter(this, (GeneratorAdapterFactory)this){

                    @Override
                    protected void createImportManager(String packageName, String className) {
                        this.importManager = new ImportManagerHack(packageName, (Function<String, String>)GeneratorAdapterDescriptor.this.typeMapper);
                        this.importManager.addMasterImport(packageName, className);
                        if (this.generatingObject != null) {
                            ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
                        }
                    }
                };
            }

            @Override
            public Adapter createGenModelAdapter() {
                if (this.genModelGeneratorAdapter == null) {
                    this.genModelGeneratorAdapter = new GenModelGeneratorAdapter((GeneratorAdapterFactory)this){

                        protected void createImportManager(String packageName, String className) {
                            this.importManager = new ImportManagerHack(packageName, (Function<String, String>)GeneratorAdapterDescriptor.this.typeMapper);
                            this.importManager.addMasterImport(packageName, className);
                            if (this.generatingObject != null) {
                                ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
                            }
                        }
                    };
                }
                return this.genModelGeneratorAdapter;
            }

            @Override
            public Adapter createGenPackageAdapter() {
                return new CvsIdFilteringGeneratorAdapterFactoryDescriptor.IdFilteringGenModelGeneratorAdapterFactory.IdFilteringGenPackageAdapter(this, (GeneratorAdapterFactory)this){

                    @Override
                    protected void createImportManager(String packageName, String className) {
                        this.importManager = new ImportManagerHack(packageName, (Function<String, String>)GeneratorAdapterDescriptor.this.typeMapper);
                        this.importManager.addMasterImport(packageName, className);
                        if (this.generatingObject != null) {
                            ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
                        }
                    }
                };
            }
        }
    }

    protected static class ImportManagerHack
    extends ImportManager {
        private Function<String, String> typeMapper;

        public ImportManagerHack(String compilationUnitPackage, Function<String, String> typeMapper) {
            super(compilationUnitPackage);
            this.typeMapper = typeMapper;
        }

        public String getImportedName(String qualifiedName, boolean autoImport) {
            String mapped = (String)this.typeMapper.apply((Object)qualifiedName);
            if (mapped != null) {
                log.debug((Object)("mapping " + qualifiedName + " to " + mapped));
                return super.getImportedName(mapped, autoImport);
            }
            return super.getImportedName(qualifiedName, autoImport);
        }
    }

    protected final class mapper
    implements Function<String, String> {
        protected mapper() {
        }

        public String apply(String from) {
            if (from.startsWith("org.eclipse.emf.ecore")) {
                return null;
            }
            String customClassName = String.valueOf(from) + "Custom";
            String fromPath = from.replace('.', '/');
            for (String srcPath : EcoreGenerator.this.srcPaths) {
                URI createURI = URI.createURI((String)(String.valueOf(srcPath) + "/" + fromPath + "Custom.java"));
                if (URIConverter.INSTANCE.exists(createURI, null)) {
                    return customClassName;
                }
                if (!from.endsWith("Impl") || !EcoreGenerator.this.generateCustomClasses) continue;
                EcoreGenerator.this.generate(from, customClassName, createURI);
                return customClassName;
            }
            if (this.getClass().getClassLoader().getResourceAsStream(String.valueOf(fromPath) + "Custom.class") != null) {
                return customClassName;
            }
            return null;
        }
    }
}

