/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.editor.controls;

import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.editor.controls.TableColumnsDMRTableControl;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.ecp.view.spi.table.model.VTablePackage;
import org.eclipse.emf.emfforms.spi.view.annotation.model.VAnnotation;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.ide.view.segments.ToolingModeUtil;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(name="TableColumnsDMRTableControlService")
public class TableColumnsDMRTableControlService
implements EMFFormsDIRendererService<VControl> {
    private static final String SHOW_CHILD_DOMAIN_MODEL_REFERENCES = "showChildDomainModelReferences";
    private EMFFormsDatabinding databindingService;
    private ReportService reportService;

    @Reference(unbind="-")
    protected void setEMFFormsDatabinding(EMFFormsDatabinding databindingService) {
        this.databindingService = databindingService;
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (ToolingModeUtil.isSegmentToolingEnabled()) {
            return Double.NaN;
        }
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        if (viewModelContext.getDomainModel().eClass() != VTablePackage.Literals.TABLE_CONTROL) {
            return Double.NaN;
        }
        if (!this.checkAnnotation(control)) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databindingService.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        EStructuralFeature feature = (EStructuralFeature)valueProperty.getValueType();
        if (VViewPackage.eINSTANCE.getControl_DomainModelReference() != feature && VTablePackage.Literals.TABLE_DOMAIN_MODEL_REFERENCE__COLUMN_DOMAIN_MODEL_REFERENCES != feature) {
            return Double.NaN;
        }
        return 10.0;
    }

    private boolean checkAnnotation(VControl control) {
        boolean showChildDmrs = false;
        for (VAttachment attachment : control.getAttachments()) {
            VAnnotation annotation;
            if (!VAnnotation.class.isInstance(attachment) || !SHOW_CHILD_DOMAIN_MODEL_REFERENCES.equals((annotation = (VAnnotation)attachment).getKey())) continue;
            showChildDmrs = true;
            break;
        }
        return showChildDmrs;
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return TableColumnsDMRTableControl.class;
    }
}

