/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.DiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DependencyData {
    private final IEMFCompareConfiguration compareConfiguration;
    private Set<Diff> requires;
    private Set<Diff> rejectedDiffs;
    private static final Function<Object, EObject> ADAPTER__TARGET__DATA = new Function<Object, EObject>(){

        public EObject apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object);
        }
    };

    public DependencyData(IEMFCompareConfiguration compareConfiguration) {
        this.compareConfiguration = compareConfiguration;
        this.requires = Sets.newHashSet();
        this.rejectedDiffs = Sets.newHashSet();
    }

    protected IDiffRelationshipComputer getDiffRelationshipComputer(IMerger.Registry mergerRegistry) {
        if (this.compareConfiguration == null || this.compareConfiguration.getDiffRelationshipComputer() == null) {
            return new DiffRelationshipComputer(mergerRegistry);
        }
        IDiffRelationshipComputer diffRelationshipComputer = this.compareConfiguration.getDiffRelationshipComputer();
        diffRelationshipComputer.setMergerRegistry(mergerRegistry);
        return diffRelationshipComputer;
    }

    public void updateDependencies(ISelection selection, IMerger.Registry mergerRegistry) {
        boolean leftEditable = this.compareConfiguration.isLeftEditable();
        boolean rightEditable = this.compareConfiguration.isRightEditable();
        if (leftEditable || rightEditable) {
            Iterable selectedDiffs = Iterables.filter(DependencyData.getSelectedComparisonObjects(selection), Diff.class);
            MergeMode mergePreviewMode = this.compareConfiguration.getMergePreviewMode();
            if (this.compareConfiguration.isMirrored() && (mergePreviewMode == MergeMode.LEFT_TO_RIGHT || mergePreviewMode == MergeMode.RIGHT_TO_LEFT)) {
                mergePreviewMode = mergePreviewMode.inverse();
            }
            this.requires = Sets.newHashSet();
            this.rejectedDiffs = Sets.newHashSet();
            for (Diff diff : selectedDiffs) {
                boolean leftToRight = mergePreviewMode.isLeftToRight(diff, leftEditable, rightEditable);
                IDiffRelationshipComputer computer = this.getDiffRelationshipComputer(mergerRegistry);
                this.requires.addAll(computer.getAllResultingMerges(diff, !leftToRight));
                this.requires.remove(diff);
                this.rejectedDiffs.addAll(computer.getAllResultingRejections(diff, !leftToRight));
                this.rejectedDiffs.remove(diff);
                this.requires.removeAll(this.rejectedDiffs);
            }
        }
    }

    public void clearDependencies() {
        this.requires = Sets.newHashSet();
        this.rejectedDiffs = Sets.newHashSet();
    }

    private static List<EObject> getSelectedComparisonObjects(ISelection selection) {
        ArrayList ret = Lists.newArrayList();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            Iterable data = Iterables.transform((Iterable)selectedObjects, ADAPTER__TARGET__DATA);
            Iterable notNullData = Iterables.filter((Iterable)data, (Predicate)Predicates.notNull());
            Iterables.addAll((Collection)ret, (Iterable)notNullData);
        }
        return ret;
    }

    public Set<Diff> getRequires() {
        return this.requires;
    }

    public Set<Diff> getRejections() {
        return this.rejectedDiffs;
    }

    public Collection<TreeNode> getTreeNodes(Diff diff) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        IDifferenceGroupProvider groupProvider = this.compareConfiguration.getStructureMergeViewerGrouper().getProvider();
        nodes.addAll(groupProvider.getTreeNodes((EObject)diff));
        return nodes;
    }
}

