/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.terminal;

import java.util.Map;
import org.eclipse.cdt.arduino.ui.internal.terminal.ArduinoTerminalSettings;
import org.eclipse.cdt.arduino.ui.internal.terminal.ArduinoTerminalSettingsPage;
import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanel;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;

public class ArduinoTerminalConfigPanel
extends AbstractExtendedConfigurationPanel {
    private ArduinoTerminalSettings settings;
    private ArduinoTerminalSettingsPage page;

    public ArduinoTerminalConfigPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        this.settings = new ArduinoTerminalSettings();
        this.page = new ArduinoTerminalSettingsPage(this.settings, (IConfigurationPanel)this);
        this.page.createControl(panel);
        this.createEncodingUI(panel, true);
        this.setControl(panel);
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.page.saveSettings();
        data.put("arduino.board", this.settings.getBoardName());
        data.put("cdtserial.portName", this.settings.getPortName());
        data.put("cdtserial.baudRate", this.settings.getBaudRate());
        data.put("cdtserial.byteSize", this.settings.getByteSize());
        data.put("cdtserial.parity", this.settings.getParity());
        data.put("cdtserial.stopBits", this.settings.getStopBits());
        if (this.getEncoding() != null) {
            data.put("encoding", this.getEncoding());
        }
    }

    public void setupData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        this.settings.setBoardName((String)data.get("arduino.board"));
        this.settings.setPortName((String)data.get("cdtserial.portName"));
        this.settings.setBaudRate((BaudRate)data.get("cdtserial.baudRate"));
        this.settings.setByteSize((ByteSize)data.get("cdtserial.byteSize"));
        this.settings.setParity((Parity)data.get("cdtserial.parity"));
        this.settings.setStopBits((StopBits)data.get("cdtserial.stopBits"));
        String encoding = (String)data.get("encoding");
        if (encoding != null) {
            this.setEncoding(encoding);
        }
    }

    protected void saveSettingsForHost(boolean add) {
    }

    protected void fillSettingsForHost(String host) {
    }

    protected String getHostFromSettings() {
        if (this.page != null) {
            this.page.saveSettings();
            return this.settings.getPortName();
        }
        return null;
    }
}

