/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.ui.internal.downloads;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoManager;
import org.eclipse.cdt.arduino.core.internal.board.ArduinoPlatform;
import org.eclipse.cdt.arduino.ui.internal.Activator;
import org.eclipse.cdt.arduino.ui.internal.FormTextHoverManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class UpdatePlatformsDialog
extends Dialog {
    private final Collection<ArduinoPlatform> platforms;
    private Collection<ArduinoPlatform> selectedPlatforms;
    private Table table;

    protected UpdatePlatformsDialog(Shell parentShell, Collection<ArduinoPlatform> platforms) {
        super(parentShell);
        this.platforms = platforms;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        Point size = super.getInitialSize();
        if (size.x < 500 || size.y < 300) {
            return new Point(500, 300);
        }
        return size;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(1808));
        this.table = new Table(comp, 68128);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn packageColumn = new TableColumn(this.table, 16384);
        packageColumn.setText("Package");
        tableLayout.setColumnData((Widget)packageColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        TableColumn platformColumn = new TableColumn(this.table, 16384);
        platformColumn.setText("Platform");
        tableLayout.setColumnData((Widget)platformColumn, (ColumnLayoutData)new ColumnWeightData(5, 150, true));
        TableColumn versionColumn = new TableColumn(this.table, 16384);
        versionColumn.setText("Current");
        tableLayout.setColumnData((Widget)versionColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        TableColumn updateColumn = new TableColumn(this.table, 16384);
        updateColumn.setText("Available");
        tableLayout.setColumnData((Widget)updateColumn, (ColumnLayoutData)new ColumnWeightData(2, 75, true));
        comp.setLayout((Layout)tableLayout);
        ArduinoManager manager = Activator.getService(ArduinoManager.class);
        for (ArduinoPlatform platform : ArduinoManager.getSortedPlatforms(this.platforms)) {
            try {
                ArduinoPlatform installed = manager.getInstalledPlatform(platform.getPackage().getName(), platform.getArchitecture());
                TableItem item = new TableItem(this.table, 0);
                item.setData((Object)platform);
                item.setText(0, platform.getPackage().getName());
                item.setText(1, platform.getName());
                item.setText(2, installed.getVersion());
                item.setText(3, platform.getVersion());
            }
            catch (CoreException e) {
                Activator.log((Exception)((Object)e));
            }
        }
        FormTextHoverManager hoverManager = new FormTextHoverManager(){

            protected void computeInformation() {
                TableItem item = UpdatePlatformsDialog.this.table.getItem(this.getHoverEventLocation());
                if (item != null) {
                    ArduinoPlatform platform = (ArduinoPlatform)item.getData();
                    this.setInformation(platform.toFormText(), item.getBounds());
                } else {
                    this.setInformation(null, null);
                }
            }
        };
        hoverManager.install((Control)this.table);
        UpdatePlatformsDialog.applyDialogFont((Control)comp);
        return comp;
    }

    protected void okPressed() {
        this.selectedPlatforms = new ArrayList<ArduinoPlatform>();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getChecked()) {
                this.selectedPlatforms.add((ArduinoPlatform)item.getData());
            }
            ++n2;
        }
        super.okPressed();
    }

    public Collection<ArduinoPlatform> getSelectedPlatforms() {
        return this.selectedPlatforms;
    }
}

