/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpel.common.ui.layouts.AlignedFlowLayout;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.EventHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.BPELEditDomain;
import org.eclipse.bpel.ui.adapters.IEventHandlerHolder;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.delegates.ActivityContainer;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.FaultHandlerEditPart;
import org.eclipse.bpel.ui.editparts.StartNodeEditPart;
import org.eclipse.bpel.ui.editparts.policies.BPELContainerEditPolicy;
import org.eclipse.bpel.ui.editparts.policies.BPELOrderedLayoutEditPolicy;
import org.eclipse.bpel.ui.figures.ILayoutAware;
import org.eclipse.bpel.ui.figures.ProcessHandlerLinker;
import org.eclipse.bpel.ui.uiextensionmodel.impl.StartNodeImpl;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ImplicitLinkHandlerConnectionRouter;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class ProcessEditPart
extends BPELEditPart
implements ILayoutAware {
    private IFigure layeredPane;
    private IFigure activityAndHandlerHolder;
    private IFigure activityHolder;
    private IFigure handlerHolder;
    private Layer activityLayer;
    private boolean showFH = false;
    private boolean showEH = false;
    private ProcessHandlerLinker handlerLinker;

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("ComponentEditPolicy", null);
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new BPELContainerEditPolicy());
        if (ModelHelper.isHorizontalLayout(this.getModel())) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProcessOrderedHorizontalLayoutEditPolicy());
        } else {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProcessOrderedLayoutEditPolicy());
        }
    }

    @Override
    protected IFigure createFigure() {
        Layer layer2;
        LayeredPane result = new LayeredPane();
        this.layeredPane = result;
        this.activityLayer = layer2 = new Layer();
        this.activityLayer.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.activityLayer.setOpaque(true);
        result.add((IFigure)layer2, (Object)"activityLayer", 0);
        this.activityAndHandlerHolder = new Figure();
        AlignedFlowLayout layout = new AlignedFlowLayout();
        layout.setHorizontalAlignment(0);
        layout.setVerticalAlignment(1);
        layout.setSecondaryAlignment(0);
        this.activityAndHandlerHolder.setLayoutManager((LayoutManager)layout);
        this.handlerHolder = new Figure();
        layout = new AlignedFlowLayout(true);
        layout.setHorizontalAlignment(1);
        this.handlerHolder.setLayoutManager((LayoutManager)layout);
        this.activityHolder = new Figure();
        layout = new AlignedFlowLayout();
        layout.setHorizontalAlignment(0);
        layout.setVerticalAlignment(1);
        layout.setSecondaryAlignment(0);
        layout.setVerticalSpacing(14);
        this.activityHolder.setLayoutManager((LayoutManager)layout);
        this.activityHolder.setOpaque(true);
        this.activityAndHandlerHolder.add(this.handlerHolder);
        this.activityAndHandlerHolder.add(this.activityHolder);
        layer2.add(this.activityAndHandlerHolder);
        this.switchLayout(ModelHelper.isHorizontalLayout(this.getModel()));
        return this.layeredPane;
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        this.getContentPane(child).setConstraint(childFigure, constraint);
    }

    protected IFigure getContentPane(EditPart childEditPart) {
        if (childEditPart instanceof StartNodeEditPart) {
            return this.handlerHolder;
        }
        if (childEditPart instanceof FaultHandlerEditPart) {
            return this.handlerHolder;
        }
        return this.activityHolder;
    }

    public IFigure getContentPane() {
        return this.activityHolder;
    }

    @Override
    protected List getModelChildren() {
        EventHandler eventHandler;
        FaultHandler faultHandler;
        Process process = this.getProcess();
        BPELEditDomain domain = (BPELEditDomain)this.getViewer().getEditDomain();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(domain.getStartNode());
        ActivityContainer container = new ActivityContainer(BPELPackage.eINSTANCE.getProcess_Activity());
        list.addAll(container.getChildren(process));
        list.add(domain.getEndNode());
        if (this.showFH && (faultHandler = process.getFaultHandlers()) != null) {
            list.add(faultHandler);
        }
        if (this.showEH && (eventHandler = process.getEventHandlers()) != null) {
            list.add(eventHandler);
        }
        return list;
    }

    public boolean isShowFH() {
        return this.showFH;
    }

    public boolean isShowEH() {
        return this.showEH;
    }

    public FaultHandler getFaultHandler() {
        IFaultHandlerHolder holder = BPELUtil.adapt(this.getModel(), IFaultHandlerHolder.class);
        if (holder != null) {
            return holder.getFaultHandler(this.getModel());
        }
        return null;
    }

    public EventHandler getEventHandler() {
        IEventHandlerHolder holder = BPELUtil.adapt(this.getModel(), IEventHandlerHolder.class);
        if (holder != null) {
            return holder.getEventHandler(this.getModel());
        }
        return null;
    }

    protected Process getProcess() {
        return (Process)this.getModel();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure content = this.getContentPane(childEditPart);
        if (content != null) {
            if (content == this.activityHolder) {
                content.add(child, index - 1);
            } else if (content == this.handlerHolder) {
                content.add(child, this.getIndexForChild(content, childEditPart));
            }
        }
    }

    private int getIndexForChild(IFigure container, EditPart child) {
        int result = 0;
        if (!(child.getModel() instanceof StartNodeImpl)) {
            int i = container.getChildren().size();
            result = i <= 1 || child.getModel() instanceof FaultHandler ? (i > 1 ? 2 : 1) : 1;
        }
        return result;
    }

    protected void removeChildVisual(EditPart childEditPart) {
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        IFigure content = this.getContentPane(childEditPart);
        if (content != null) {
            content.remove(child);
        }
    }

    protected void reorderChild(EditPart child, int index) {
        IFigure childFigure = ((GraphicalEditPart)child).getFigure();
        LayoutManager layout = this.getContentPane(child).getLayoutManager();
        Object constraint = null;
        if (layout != null) {
            constraint = layout.getConstraint(childFigure);
        }
        this.removeChildVisual(child);
        List children = this.getChildren();
        children.remove(child);
        children.add(index, child);
        this.addChildVisual(child, index);
        this.setLayoutConstraint(child, childFigure, constraint);
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            return;
        }
        super.performRequest(request);
    }

    public void setShowFaultHandler(boolean showFaultHandler) {
        this.showFH = showFaultHandler;
        this.refresh();
    }

    public void setShowEventHandler(boolean showEventHandler) {
        this.showEH = showEventHandler;
        this.refresh();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new MarqueeDragTracker(){

            protected void handleFinished() {
                if (ProcessEditPart.this.getViewer().getSelection().isEmpty()) {
                    ProcessEditPart.this.getViewer().setSelection((ISelection)new StructuredSelection((Object)ProcessEditPart.this));
                }
            }
        };
    }

    @Override
    public void switchLayout(boolean horizontal) {
        AlignedFlowLayout handlerLayout = (AlignedFlowLayout)this.handlerHolder.getLayoutManager();
        handlerLayout.setHorizontal(!horizontal);
        ((AlignedFlowLayout)this.activityAndHandlerHolder.getLayoutManager()).setHorizontal(horizontal);
        ((AlignedFlowLayout)this.activityHolder.getLayoutManager()).setHorizontal(horizontal);
        this.removeEditPolicy("LayoutEditPolicy");
        if (horizontal) {
            handlerLayout.setSecondaryAlignment(1);
            this.activityAndHandlerHolder.setBorder((Border)new MarginBorder(20, 20, 0, 20));
            this.handlerHolder.setBorder((Border)new MarginBorder(0, 20, 0, 0));
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProcessOrderedHorizontalLayoutEditPolicy());
        } else {
            handlerLayout.setSecondaryAlignment(1);
            this.activityAndHandlerHolder.setBorder(null);
            this.handlerHolder.setBorder((Border)new AbstractBorder(){

                public Insets getInsets(IFigure arg0) {
                    return new Insets(20, 0, 10, 0);
                }

                public void paint(IFigure arg0, Graphics arg1, Insets arg2) {
                }
            });
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new ProcessOrderedLayoutEditPolicy());
        }
    }

    @Override
    protected void clearConnections() {
        super.clearConnections();
        this.getHandlerLinker().clearHandlerConnections();
    }

    public void refresh() {
        super.refresh();
        this.getHandlerLinker().refreshHandlerLinks();
    }

    private ProcessHandlerLinker getHandlerLinker() {
        if (this.handlerLinker == null) {
            this.handlerLinker = new ProcessHandlerLinker(this);
        }
        return this.handlerLinker;
    }

    @Override
    protected void handleModelChanged() {
        super.handleModelChanged();
        this.showFH = this.getFaultHandler() != null;
        this.showEH = this.getEventHandler() != null;
        this.refresh();
    }

    private class ProcessOrderedHorizontalLayoutEditPolicy
    extends ProcessOrderedLayoutEditPolicy {
        private ProcessOrderedHorizontalLayoutEditPolicy() {
        }

        protected ArrayList createHorizontalConnections(BPELEditPart parent) {
            ArrayList<PolylineConnection> connections = new ArrayList<PolylineConnection>();
            List children = this.getConnectionChildren(parent);
            int i = 0;
            while (i < children.size()) {
                if (i != children.size() - 1) {
                    BPELEditPart sourcePart = (BPELEditPart)children.get(i);
                    BPELEditPart targetPart = (BPELEditPart)children.get(i + 1);
                    ConnectionAnchor sourceAnchor = sourcePart.getConnectionAnchor(3);
                    ConnectionAnchor targetAnchor = targetPart.getConnectionAnchor(2);
                    PolylineConnection connection = this.createConnection(sourceAnchor, targetAnchor, this.arrowColor);
                    if (sourcePart instanceof StartNodeEditPart) {
                        boolean horizontal = ModelHelper.isHorizontalLayout(this.getHost().getModel());
                        connection.setConnectionRouter((ConnectionRouter)new ImplicitLinkHandlerConnectionRouter(horizontal));
                    }
                    connections.add(connection);
                }
                ++i;
            }
            return connections;
        }
    }

    public class ProcessOrderedLayoutEditPolicy
    extends BPELOrderedLayoutEditPolicy {
        protected List getConnectionChildren(BPELEditPart editPart) {
            List originalChildren = ProcessEditPart.this.getChildren();
            ArrayList newChildren = new ArrayList();
            for (Object next : originalChildren) {
                if (next instanceof FaultHandlerEditPart) continue;
                newChildren.add(next);
            }
            return newChildren;
        }

        @Override
        protected Command getCreateCommand(CreateRequest request) {
            EditPart insertBefore = this.getInsertionReference((Request)request);
            if (insertBefore == null) {
                return null;
            }
            if (insertBefore instanceof StartNodeEditPart) {
                return null;
            }
            return super.getCreateCommand(request);
        }
    }
}

