/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.editparts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Link;
import org.eclipse.bpel.model.Source;
import org.eclipse.bpel.model.Sources;
import org.eclipse.bpel.model.Target;
import org.eclipse.bpel.model.Targets;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.IHoverHelper;
import org.eclipse.bpel.ui.adapters.IMarkerHolder;
import org.eclipse.bpel.ui.editparts.BPELEditPart;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.bpel.ui.editparts.LinkEditPart;
import org.eclipse.bpel.ui.editparts.borders.DrawerBorder;
import org.eclipse.bpel.ui.editparts.policies.BPELGraphicalEditPolicy;
import org.eclipse.bpel.ui.extensions.BPELUIRegistry;
import org.eclipse.bpel.ui.figures.CenteredConnectionAnchor;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;

public abstract class ActivityEditPart
extends BPELEditPart
implements NodeEditPart {
    private MouseMotionListener mouseMotionListener;

    @Override
    protected void addAllAdapters() {
        Targets targets;
        super.addAllAdapters();
        Sources sources = this.getActivity().getSources();
        if (sources != null) {
            this.adapter.addToObject((Notifier)sources);
            for (Source source : sources.getChildren()) {
                this.adapter.addToObject((Notifier)source);
            }
        }
        if ((targets = this.getActivity().getTargets()) != null) {
            this.adapter.addToObject((Notifier)targets);
            for (Target target : targets.getChildren()) {
                this.adapter.addToObject((Notifier)target);
            }
        }
    }

    @Override
    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new BPELGraphicalEditPolicy());
    }

    protected List<Link> getModelSourceConnections() {
        Sources sources = this.getActivity().getSources();
        if (sources == null) {
            return Collections.emptyList();
        }
        ArrayList<Link> result = new ArrayList<Link>();
        for (Source source : sources.getChildren()) {
            if (source.getLink() == null) continue;
            result.add(source.getLink());
        }
        return result;
    }

    protected List<Link> getModelTargetConnections() {
        Targets targets = this.getActivity().getTargets();
        if (targets == null) {
            return Collections.emptyList();
        }
        ArrayList<Link> result = new ArrayList<Link>();
        for (Target target : targets.getChildren()) {
            if (target.getLink() == null) continue;
            result.add(target.getLink());
        }
        return result;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return this.getSourceConnectionAnchor((ConnectionEditPart)null);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getTargetConnectionAnchor((ConnectionEditPart)null);
    }

    @Override
    protected void handleModelChanged() {
        super.handleModelChanged();
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    public Activity getActivity() {
        return (Activity)this.getModel();
    }

    @Override
    public void refreshVisuals() {
        RootEditPart root;
        Rectangle r = null;
        if (this.getParent() instanceof FlowEditPart && (root = this.getRoot()) instanceof GraphicalBPELRootEditPart) {
            Point p = ModelHelper.getLocation(this.getActivity());
            if (p.x == Integer.MIN_VALUE) {
                p = new Point(0, 0);
            }
            Dimension s = new Dimension(-1, -1);
            r = new Rectangle(p, s);
        }
        if (r != null) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), r);
        }
        super.refreshVisuals();
    }

    public ConnectionAnchor getTargetConnectionAnchorForTargetChild(ConnectionEditPart connEditPart) {
        return null;
    }

    protected void refreshDrawerHoverHelp() {
        IHoverHelper helper = null;
        try {
            helper = BPELUIRegistry.getInstance().getHoverHelper();
            if (helper == null) {
                return;
            }
        }
        catch (CoreException ce) {
            this.getFigure().setToolTip(null);
            BPELUIPlugin.log(ce);
            return;
        }
        ArrayList<IMarker> listOfMarkers = new ArrayList<IMarker>();
        IMarkerHolder holder = BPELUtil.adapt((Object)this.getActivity(), IMarkerHolder.class);
        IMarker[] iMarkerArray = holder.getMarkers(this.getActivity());
        int n = iMarkerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker m = iMarkerArray[n2];
            if (m.getAttribute("org.eclipse.bpel.common.ui.uiModelMarker.visible", true)) {
                String where = m.getAttribute("org.eclipse.bpel.common.ui.graphicalMarker.anchorPoint", EMPTY_STRING);
                if (this.mouseLocation == 1) {
                    if (where.equals("DRAWER_TOP")) {
                        listOfMarkers.add(m);
                    }
                } else if (where.equals("DRAWER_BOTTOM")) {
                    listOfMarkers.add(m);
                }
            }
            ++n2;
        }
        if (listOfMarkers.size() == 0) {
            return;
        }
        String text = null;
        if (listOfMarkers.size() == 1) {
            text = helper.getHoverHelp((IMarker)listOfMarkers.get(0));
        } else {
            StringBuilder sb = new StringBuilder();
            sb.append("There are ").append(listOfMarkers.size()).append(" issues here:\n");
            for (IMarker m : listOfMarkers) {
                String t = helper.getHoverHelp(m);
                sb.append("o ").append(t).append("\n");
            }
            text = sb.toString();
        }
        if (text == null || text.length() < 1) {
            this.getFigure().setToolTip(null);
        } else {
            this.getFigure().setToolTip((IFigure)new Label(text));
        }
    }

    protected MouseMotionListener getMouseMotionListener() {
        if (this.mouseMotionListener == null) {
            this.mouseMotionListener = new MouseMotionListener(){

                public void mouseDragged(MouseEvent me) {
                }

                public void mouseEntered(MouseEvent me) {
                }

                public void mouseExited(MouseEvent me) {
                }

                public void mouseHover(MouseEvent me) {
                }

                public void mouseMoved(MouseEvent me) {
                    int inBottom;
                    DrawerBorder border = ActivityEditPart.this.getDrawerBorder();
                    if (border == null) {
                        return;
                    }
                    int inTop = border.isPointInTopDrawer(me.x, me.y) ? 1 : 0;
                    int newLocation = inTop | (inBottom = border.isPointInBottomDrawer(me.x, me.y) ? 2 : 0);
                    if (newLocation == ActivityEditPart.this.mouseLocation) {
                        return;
                    }
                    ActivityEditPart.this.mouseLocation = newLocation;
                    ActivityEditPart.this.refreshHoverHelp();
                }
            };
        }
        return this.mouseMotionListener;
    }

    protected abstract DrawerBorder getDrawerBorder();

    @Override
    public void refreshHoverHelp() {
        switch (this.mouseLocation) {
            case 1: {
                this.refreshDrawerHoverHelp();
                return;
            }
            case 2: {
                this.refreshDrawerHoverHelp();
                return;
            }
        }
        super.refreshHoverHelp();
    }

    public IFigure getMainActivityFigure() {
        return this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart == null || connEditPart instanceof LinkEditPart) {
            if (ModelHelper.isHorizontalLayout(this.getModel())) {
                return new CenteredConnectionAnchor(this.getMainActivityFigure(), 7, 0);
            }
            return new CenteredConnectionAnchor(this.getMainActivityFigure(), 1, 0);
        }
        return null;
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connEditPart) {
        if (connEditPart == null || connEditPart instanceof LinkEditPart) {
            if (ModelHelper.isHorizontalLayout(this.getModel())) {
                return new CenteredConnectionAnchor(this.getMainActivityFigure(), 6, 0);
            }
            return new CenteredConnectionAnchor(this.getMainActivityFigure(), 0, 0);
        }
        return null;
    }
}

