/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.model.util;

import javax.xml.namespace.QName;
import org.eclipse.bpel.model.BPELPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;

public final class BPELProxyURI {
    private URI baseURI = null;
    private String proxyType = null;
    private EClass type = null;
    private String typeName = null;
    private QName qName = null;
    private String optionalID = null;

    public BPELProxyURI(String proxyType, EClass type, URI baseURI, QName qName) {
        this(type, baseURI, qName);
        this.proxyType = proxyType;
    }

    public BPELProxyURI(EClass type, URI baseURI, QName qName) {
        this.type = type;
        this.typeName = type.getName();
        this.baseURI = baseURI;
        this.qName = qName;
        if (qName != null && qName.getNamespaceURI() != null) {
            qName.getNamespaceURI().equals("");
        }
    }

    public BPELProxyURI(EClass type, URI baseURI, QName qName, String optionalID) {
        this(type, baseURI, qName);
        this.optionalID = optionalID;
    }

    public BPELProxyURI(String uriFragment) {
        int qNameLHS = uriFragment.indexOf(123);
        int qNameRHS = uriFragment.indexOf(125, qNameLHS);
        int idLHS = uriFragment.indexOf(58, qNameRHS);
        if (qNameLHS > 0 && qNameRHS > qNameLHS) {
            int alRHS = uriFragment.substring(0, qNameLHS).indexOf(58);
            if (alRHS > 0) {
                this.proxyType = uriFragment.substring(0, alRHS);
                this.typeName = uriFragment.substring(alRHS + 1, qNameLHS);
            } else {
                this.typeName = uriFragment.substring(0, qNameLHS);
            }
            if (idLHS > 0) {
                this.qName = this.parseQName(uriFragment.substring(qNameLHS, idLHS));
                this.optionalID = uriFragment.substring(idLHS + 1);
            } else {
                this.qName = this.parseQName(uriFragment.substring(qNameLHS));
            }
        }
    }

    private QName parseQName(String qNameAsString) {
        if (qNameAsString == null) {
            throw new IllegalArgumentException("QName cannot be null");
        }
        try {
            int qNameLHS = qNameAsString.indexOf(123);
            int qNameRHS = qNameAsString.indexOf(125);
            if (qNameRHS != -1 && qNameLHS != -1 && qNameRHS > qNameLHS) {
                String namespace = qNameAsString.substring(qNameLHS + 1, qNameRHS);
                if (namespace == null || namespace.trim().equals("")) {
                    return QName.valueOf(qNameAsString.substring(qNameRHS + 1));
                }
                return QName.valueOf(qNameAsString);
            }
        }
        catch (Exception e) {
            BPELPlugin.log("Error parsing QName " + qNameAsString, e);
        }
        return null;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public QName getQName() {
        return this.qName;
    }

    public String getID() {
        return this.optionalID;
    }

    public String getFragment() {
        String fragmentQName = this.qName.toString();
        if (this.qName.getNamespaceURI() == null || this.qName.getNamespaceURI().length() == 0) {
            fragmentQName = "{}" + fragmentQName;
        }
        return String.valueOf(this.proxyType == null ? "" : String.valueOf(this.proxyType) + ":") + this.typeName + fragmentQName + (this.optionalID == null ? "" : ":" + this.optionalID);
    }

    public URI getProxyURI() {
        return this.baseURI.appendFragment(this.getFragment());
    }

    public String toString() {
        return String.valueOf(super.toString()) + "[baseURI=" + this.baseURI + ", proxyType=" + this.proxyType + ", typeName=" + this.typeName + ", qName=" + this.qName + ", optionalID=" + this.optionalID + "]";
    }
}

