/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;

public class MultiElementSlot
extends ContainerSlot {
    public ArrayList<DesignElement> contents = new ArrayList();

    @Override
    public Object doClone(CopyPolicy policy) throws CloneNotSupportedException {
        MultiElementSlot slot = (MultiElementSlot)super.clone();
        slot.contents = new ArrayList();
        int i = 0;
        while (i < this.contents.size()) {
            DesignElement e = this.contents.get(i);
            slot.contents.add((DesignElement)e.doClone(policy));
            ++i;
        }
        return slot;
    }

    @Override
    public int findPosn(DesignElement content) {
        return this.contents.indexOf(content);
    }

    @Override
    public void insert(DesignElement element, int posn) {
        assert (!this.contents.contains(element));
        assert (posn >= 0 && posn <= this.contents.size());
        this.contents.add(posn, element);
    }

    @Override
    public void remove(DesignElement element) {
        assert (this.contents.contains(element));
        this.contents.remove(element);
    }

    @Override
    public Object remove(int posn) {
        assert (posn >= 0 && posn < this.getCount());
        return this.contents.remove(posn);
    }

    @Override
    public boolean canDrop(DesignElement element) {
        return this.contents.contains(element);
    }

    @Override
    public List<DesignElement> getContents() {
        return this.contents;
    }

    @Override
    public int getCount() {
        return this.contents.size();
    }

    @Override
    public void moveContent(int from, int to) {
        assert (from >= 0 && from < this.contents.size());
        assert (to >= 0 && to < this.contents.size());
        if (from == to) {
            return;
        }
        DesignElement obj = this.contents.remove(from);
        this.contents.add(to, obj);
    }

    @Override
    public boolean contains(DesignElement element) {
        return this.contents.contains(element);
    }

    @Override
    public DesignElement getContent(int posn) {
        assert (posn >= 0 && posn < this.contents.size());
        return this.contents.get(posn);
    }

    @Override
    public void clear() {
        this.contents.clear();
    }
}

