/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.ColorHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.FontHandle;
import org.eclipse.birt.report.model.api.FormatValueHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.StyleRuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.DateTimeFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.api.elements.structures.NumberFormatValue;
import org.eclipse.birt.report.model.api.elements.structures.StringFormatValue;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.StructureContextUtil;

public class HighlightRuleHandle
extends StyleRuleHandle {
    public HighlightRuleHandle(SimpleValueHandle valueHandle, int index) {
        super(valueHandle, index);
    }

    public ColorHandle getColor() {
        return this.doGetColorHandle("color");
    }

    public ColorHandle getBackgroundColor() {
        return this.doGetColorHandle("backgroundColor");
    }

    public ColorHandle getBorderTopColor() {
        return this.doGetColorHandle("borderTopColor");
    }

    public ColorHandle getBorderLeftColor() {
        return this.doGetColorHandle("borderLeftColor");
    }

    public ColorHandle getBorderRightColor() {
        return this.doGetColorHandle("borderRightColor");
    }

    public ColorHandle getBorderBottomColor() {
        return this.doGetColorHandle("borderBottomColor");
    }

    private ColorHandle doGetColorHandle(String memberName) {
        return new ColorHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
    }

    public String getBorderBottomStyle() {
        return this.getStringProperty("borderBottomStyle");
    }

    public void setBorderBottomStyle(String value) throws SemanticException {
        this.setProperty("borderBottomStyle", value);
    }

    public String getBorderLeftStyle() {
        return this.getStringProperty("borderLeftStyle");
    }

    public void setBorderLeftStyle(String value) throws SemanticException {
        this.setProperty("borderLeftStyle", value);
    }

    public String getBorderRightStyle() {
        return this.getStringProperty("borderRightStyle");
    }

    public void setBorderRightStyle(String value) throws SemanticException {
        this.setProperty("borderRightStyle", value);
    }

    public String getBorderTopStyle() {
        return this.getStringProperty("borderTopStyle");
    }

    public void setBorderTopStyle(String value) throws SemanticException {
        this.setProperty("borderTopStyle", value);
    }

    public String getTestExpression() {
        return this.getStringProperty("testExpr");
    }

    public void setTestExpression(String expression) {
        this.setPropertySilently("testExpr", expression);
    }

    public String getTextUnderline() {
        return this.getStringProperty("textUnderline");
    }

    public void setTextUnderline(String value) throws SemanticException {
        this.setProperty("textUnderline", value);
    }

    public String getTextOverline() {
        return this.getStringProperty("textOverline");
    }

    public void setTextOverline(String value) throws SemanticException {
        this.setProperty("textOverline", value);
    }

    public String getTextLineThrough() {
        return this.getStringProperty("textLineThrough");
    }

    public void setTextLineThrough(String value) throws SemanticException {
        this.setProperty("textLineThrough", value);
    }

    public String getTextAlign() {
        return this.getStringProperty("textAlign");
    }

    public void setTextAlign(String value) throws SemanticException {
        this.setProperty("textAlign", value);
    }

    public String getTextDirection() {
        return this.getStringProperty("bidiTextDirection");
    }

    public void setTextDirection(String value) throws SemanticException {
        this.setProperty("bidiTextDirection", value);
    }

    public String getTextTransform() {
        return this.getStringProperty("textTransform");
    }

    public void setTextTransform(String value) throws SemanticException {
        this.setProperty("textTransform", value);
    }

    public DimensionHandle getTextIndent() {
        return this.doGetDimensionHandle("textIndent");
    }

    public String getNumberAlign() {
        return this.getStringProperty("numberAlign");
    }

    public void setNumberAlign(String value) {
        this.setPropertySilently("numberAlign", value);
    }

    public DimensionHandle getBorderTopWidth() {
        return this.doGetDimensionHandle("borderTopWidth");
    }

    public DimensionHandle getBorderLeftWidth() {
        return this.doGetDimensionHandle("borderLeftWidth");
    }

    public DimensionHandle getBorderRightWidth() {
        return this.doGetDimensionHandle("borderRightWidth");
    }

    public DimensionHandle getBorderBottomWidth() {
        return this.doGetDimensionHandle("borderBottomWidth");
    }

    public DimensionHandle getFontSize() {
        return this.doGetDimensionHandle("fontSize");
    }

    private DimensionHandle doGetDimensionHandle(String memberName) {
        return new DimensionHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, memberName));
    }

    public FontHandle getFontFamilyHandle() {
        return new FontHandle(this.getElementHandle(), StructureContextUtil.createStructureContext(this, "fontFamily"));
    }

    public String getFontWeight() {
        return this.getStringProperty("fontWeight");
    }

    public void setFontWeight(String value) throws SemanticException {
        this.setProperty("fontWeight", value);
    }

    public String getFontVariant() {
        return this.getStringProperty("fontVariant");
    }

    public void setFontVariant(String value) throws SemanticException {
        this.setProperty("fontVariant", value);
    }

    public String getFontStyle() {
        return this.getStringProperty("fontStyle");
    }

    public void setFontStyle(String value) throws SemanticException {
        this.setProperty("fontStyle", value);
    }

    public String getStringFormat() {
        Object value = this.getProperty("stringFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof StringFormatValue);
        return ((StringFormatValue)value).getPattern();
    }

    public String getStringFormatCategory() {
        Object value = this.getProperty("stringFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof StringFormatValue);
        return ((StringFormatValue)value).getCategory();
    }

    public void setStringFormat(String pattern) {
        block2: {
            try {
                this.setFormatValue("stringFormat", "pattern", pattern);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setStringFormatCategory(String category) throws SemanticException {
        this.setFormatValue("stringFormat", "category", category);
    }

    public String getNumberFormat() {
        Object value = this.getProperty("numberFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof NumberFormatValue);
        return ((NumberFormatValue)value).getPattern();
    }

    public String getNumberFormatCategory() {
        Object value = this.getProperty("numberFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof NumberFormatValue);
        return ((NumberFormatValue)value).getCategory();
    }

    public void setNumberFormat(String pattern) {
        block2: {
            try {
                this.setFormatValue("numberFormat", "pattern", pattern);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setNumberFormatCategory(String category) throws SemanticException {
        this.setFormatValue("numberFormat", "category", category);
    }

    public String getDateTimeFormat() {
        Object value = this.getProperty("dateTimeFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof DateTimeFormatValue);
        return ((DateTimeFormatValue)value).getPattern();
    }

    public String getDateTimeFormatCategory() {
        Object value = this.getProperty("dateTimeFormat");
        if (value == null) {
            return null;
        }
        assert (value instanceof DateTimeFormatValue);
        return ((DateTimeFormatValue)value).getCategory();
    }

    public void setDateTimeFormat(String pattern) {
        block2: {
            try {
                this.setFormatValue("dateTimeFormat", "pattern", pattern);
            }
            catch (SemanticException semanticException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    public void setDateTimeFormatCategory(String pattern) throws SemanticException {
        this.setFormatValue("dateTimeFormat", "category", pattern);
    }

    private void setFormatValue(String propName, String memberName, String valueToSet) throws SemanticException {
        Object value = this.getProperty(propName);
        FormatValue formatValueToSet = null;
        if (value == null) {
            if ("dateTimeFormat".equalsIgnoreCase(propName)) {
                formatValueToSet = new DateTimeFormatValue();
            } else if ("numberFormat".equalsIgnoreCase(propName)) {
                formatValueToSet = new NumberFormatValue();
            } else if ("stringFormat".equalsIgnoreCase(propName)) {
                formatValueToSet = new StringFormatValue();
            } else assert (false);
            if ("category".equalsIgnoreCase(memberName)) {
                formatValueToSet.setCategory(valueToSet);
            } else if ("pattern".equalsIgnoreCase(memberName)) {
                formatValueToSet.setPattern(valueToSet);
            } else assert (false);
            this.setProperty(propName, formatValueToSet);
        } else {
            MemberHandle propHandle = this.getMember(propName);
            formatValueToSet = (FormatValue)propHandle.getValue();
            FormatValueHandle formatHandle = (FormatValueHandle)formatValueToSet.getHandle(propHandle);
            if ("category".equalsIgnoreCase(memberName)) {
                formatHandle.setCategory(valueToSet);
            } else if ("pattern".equalsIgnoreCase(memberName)) {
                formatHandle.setPattern(valueToSet);
            } else assert (false);
        }
    }

    public void setStyle(StyleHandle style) throws SemanticException {
        if (style == null) {
            this.setProperty("style", null);
            return;
        }
        this.setProperty("style", style.getElement());
    }

    public void setStyleName(String styleName) throws SemanticException {
        this.setProperty("style", styleName);
    }

    public StyleHandle getStyle() {
        ElementRefValue refValue;
        Object value = ((Structure)this.getStructure()).getLocalProperty(this.getModule(), "style");
        if (value instanceof ElementRefValue && (refValue = (ElementRefValue)value).isResolved()) {
            Style style = (Style)refValue.getElement();
            return (StyleHandle)style.getHandle(style.getRoot());
        }
        return null;
    }

    public DimensionHandle getLineHeight() {
        return this.doGetDimensionHandle("lineHeight");
    }
}

