/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.tools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerComposite;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractTableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ITableLayoutOwner;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayoutData;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableEditPart;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.editparts.CrosstabTableUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabHandleAdapter;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.graphics.Cursor;

public class CrosstabColumnDragTracker
extends TableDragGuideTracker {
    private static final String RESIZE_COLUMN_TRANS_LABEL = Messages.getString("CrosstabColumnDragTracker.ResizeColumn");
    private static final String PREFIX_LABEL = Messages.getString("CrosstabColumnDragTracker.Show.Label");

    public CrosstabColumnDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZEWE);
    }

    protected Cursor getDefaultCursor() {
        if (this.isCloneActive()) {
            return Cursors.SIZEWE;
        }
        return super.getDefaultCursor();
    }

    protected Dimension getDragWidth(int start, int end) {
        if (this.isCtrlDown()) {
            return new Dimension(TableUtil.getMinWidth((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getStart()) - CrosstabTableUtil.caleVisualWidth(this.getCrosstabTableEditPart(), this.getStart()), Integer.MAX_VALUE);
        }
        if (this.getStart() == this.getEnd()) {
            return new Dimension(TableUtil.getMinWidth((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getStart()) - CrosstabTableUtil.caleVisualWidth(this.getCrosstabTableEditPart(), this.getStart()), Integer.MAX_VALUE);
        }
        return new Dimension(TableUtil.getMinWidth((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getStart()) - CrosstabTableUtil.caleVisualWidth(this.getCrosstabTableEditPart(), this.getStart()), CrosstabTableUtil.caleVisualWidth(this.getCrosstabTableEditPart(), this.getEnd()) - TableUtil.getMinWidth((AbstractTableEditPart)this.getCrosstabTableEditPart(), (int)this.getEnd()));
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = this.getCrosstabTableEditPart().getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().x - this.getStartLocation().x;
        value = this.getTrueValueAbsolute(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(value + p.x, bounds.y + insets.top, 2, bounds.height - (insets.top + insets.bottom));
    }

    protected void resize() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int value = this.getMouseTrueValueX();
        part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().startTrans(RESIZE_COLUMN_TRANS_LABEL);
        if (this.getStart() != this.getEnd()) {
            value = this.getTrueValue(value);
            this.resizeColumn(this.getStart(), this.getEnd(), value);
        } else {
            Dimension dimension = this.getDragWidth();
            if (value < dimension.width) {
                value = dimension.width;
            }
            int with = this.calculateWidth() + value;
            int startWidth = 0;
            startWidth = CrosstabTableUtil.caleVisualWidth(part, this.getStart());
            part.getCrosstabHandleAdapter().setWidth(with);
            part.getCrosstabHandleAdapter().setColumnWidth(this.getStart(), startWidth + value);
        }
        part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack().commit();
    }

    private int calculateWidth() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int columnCount = part.getColumnCount();
        int samColumnWidth = 0;
        int i = 0;
        while (i < columnCount) {
            samColumnWidth += CrosstabTableUtil.caleVisualWidth(part, i + 1);
            ++i;
        }
        return samColumnWidth;
    }

    private void resizeFixColumn(int value, int start, int end) {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        int startWidth = 0;
        int endWidth = 0;
        startWidth = CrosstabTableUtil.caleVisualWidth(part, start);
        endWidth = CrosstabTableUtil.caleVisualWidth(part, end);
        crosstabAdapter.setColumnWidth(start, startWidth + value);
        if (!this.isCtrlDown() && start != end) {
            crosstabAdapter.setColumnWidth(end, endWidth - value);
        }
    }

    public void resizeColumn(int start, int end, int value) {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        int startWidth = 0;
        int endWidth = 0;
        startWidth = CrosstabTableUtil.caleVisualWidth(part, start);
        endWidth = CrosstabTableUtil.caleVisualWidth(part, end);
        crosstabAdapter.setColumnWidth(start, startWidth + value);
        if (!this.isCtrlDown() && start != end) {
            crosstabAdapter.setColumnWidth(end, endWidth - value);
        }
    }

    private CrosstabTableEditPart getCrosstabTableEditPart() {
        return (CrosstabTableEditPart)this.getSourceEditPart().getParent();
    }

    protected String getInfomation() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        return this.getShowLabel(CrosstabTableUtil.caleVisualWidth(part, this.getStart()));
    }

    private String getShowLabel(int pix) {
        String unit = this.getDefaultUnits();
        double doubleValue = MetricUtility.pixelToPixelInch((int)pix);
        double showValue = DimensionUtil.convertTo((double)doubleValue, (String)"in", (String)unit).getMeasure();
        return String.valueOf(PREFIX_LABEL) + " " + this.getShowValue(showValue) + " " + CrosstabColumnDragTracker.getUnitDisplayName((String)unit) + " (" + pix + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected boolean handleDragInProgress() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        boolean bool = super.handleDragInProgress();
        int value = this.getTrueValue(this.getMouseTrueValueX());
        int adjustWidth = CrosstabTableUtil.caleVisualWidth(part, this.getStart()) + value;
        this.updateInfomation(this.getShowLabel(adjustWidth));
        return bool;
    }

    protected void fitResize() {
        ArrayList<Integer> exclusion = new ArrayList<Integer>();
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        int value = this.getMouseTrueValueX();
        CommandStack stack = part.getCrosstabHandleAdapter().getCrosstabItemHandle().getModuleHandle().getCommandStack();
        stack.startTrans(RESIZE_COLUMN_TRANS_LABEL);
        int width = 0;
        exclusion.add(this.getStart());
        width += this.getTrueValue(value, this.getStart(), this.getEnd());
        this.resizeFixColumn(this.getTrueValue(value), this.getStart(), this.getEnd());
        if (!this.isCtrlDown()) {
            exclusion.add(this.getEnd());
            if (this.getStart() != this.getEnd()) {
                width = 0;
            }
        }
        Dimension tableSize = part.getFigure().getSize();
        part.getCrosstabHandleAdapter().setWidth(this.converPixToDefaultUnit(tableSize.width + width), this.getDefaultUnits());
        this.adjustOthersColumn(exclusion);
        stack.commit();
    }

    protected AbstractTableEditPart getAbstractTableEditPart() {
        return (AbstractTableEditPart)this.getSourceEditPart().getParent();
    }

    protected String getDefaultUnits() {
        CrosstabTableEditPart part = (CrosstabTableEditPart)this.getSourceEditPart().getParent();
        CrosstabHandleAdapter crosstabAdapter = part.getCrosstabHandleAdapter();
        return crosstabAdapter.getDesignElementHandle().getModuleHandle().getDefaultUnits();
    }

    protected void adjustOthersColumn(List exclusion) {
        AbstractTableEditPart part = this.getAbstractTableEditPart();
        TableLayout.WorkingData data = this.getTableWorkingData();
        TableLayoutData.ColumnData[] datas = data.columnWidths;
        if (datas == null) {
            return;
        }
        int i = 0;
        while (i < datas.length) {
            if (!exclusion.contains(datas[i].columnNumber)) {
                ITableLayoutOwner.DimensionInfomation dim = part.getColumnWidth(datas[i].columnNumber);
                if ("%".equals(dim.getUnits())) {
                    this.resizeFixColumn(0, datas[i].columnNumber, 1);
                } else if (dim.getUnits() == null || dim.getUnits().length() == 0) {
                    this.resizeFixColumn(0, datas[i].columnNumber, datas[i].columnNumber);
                }
            }
            ++i;
        }
    }

    protected EditorRulerComposite.DragGuideInfo createDragGuideInfo() {
        int value = this.getTrueValue(this.getMouseTrueValueX());
        Point p = this.getStartLocation().getCopy();
        this.getAbstractTableEditPart().getFigure().translateToRelative((Translatable)p);
        EditorRulerComposite.DragGuideInfo info = new EditorRulerComposite.DragGuideInfo(true, value += p.x);
        return info;
    }
}

