/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.attributes.provider;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.PropertyDescriptorProvider;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.LinkedDataSetAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.section.CrosstabBindingComboSection;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;

public class CrosstabBindingComboPropertyDescriptorProvider
extends PropertyDescriptorProvider {
    private static final String NONE = Messages.getString("BindingPage.None");
    private CrosstabBindingComboSection section;

    public CrosstabBindingComboPropertyDescriptorProvider(String property, String element) {
        super(property, element);
    }

    public List<CubeHandle> getItems() {
        ExtendedItemHandle handle;
        List items = null;
        Object selecteObj = this.input;
        if (this.input instanceof List) {
            selecteObj = ((List)this.input).get(0);
        }
        if (!(handle = (ExtendedItemHandle)selecteObj).getExtensionName().equals("Crosstab")) {
            return Collections.EMPTY_LIST;
        }
        if ("cube".equals(this.getProperty())) {
            items = UIUtil.getVisibleCubeHandles((ModuleHandle)handle.getModuleHandle());
        }
        Collections.sort(items, new Comparator<CubeHandle>(){

            @Override
            public int compare(CubeHandle o1, CubeHandle o2) {
                return o1.getQualifiedName().compareTo(o2.getQualifiedName());
            }
        });
        items.add(0, null);
        return items;
    }

    public String[] getItemNames() {
        List<CubeHandle> cubes = this.getItems();
        String[] items = new String[cubes.size()];
        int i = 0;
        while (i < cubes.size()) {
            CubeHandle cube = cubes.get(i);
            if (cube == null) {
                items[i] = NONE;
            } else {
                items[i] = cube.getQualifiedName();
                if (this.getExtendedItemHandle().getModuleHandle().findCube(items[i]) != cube) {
                    int n = i;
                    items[n] = String.valueOf(items[n]) + Messages.getString("CrosstabBindingComboPropertyDescriptorProvider.Flag.DataModel");
                }
            }
            ++i;
        }
        return items;
    }

    public String getDisplayName() {
        if ("cube".equals(this.getProperty())) {
            return Messages.getString("Element.ReportElement.Cube");
        }
        return super.getDisplayName();
    }

    public void save(Object value) throws SemanticException {
        int ret = 0;
        if (this.getCube() != null) {
            if (this.getCube().equals(value)) {
                return;
            }
            MessageDialog prefDialog = new MessageDialog(UIUtil.getDefaultShell(), Messages.getString("CrosstabDataBinding.title.ChangeCube"), null, Messages.getString("CrosstabDataBinding.message.changeCube"), 2, new String[]{org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.Yes"), org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.No"), org.eclipse.birt.report.designer.nls.Messages.getString((String)"AttributeView.dialg.Message.Cancel")}, 0);
            ret = prefDialog.open();
            switch (ret) {
                case 0: {
                    this.resetCubeReference((CubeHandle)value, true);
                    break;
                }
                case 1: {
                    this.resetCubeReference((CubeHandle)value, false);
                    break;
                }
                case 2: {
                    int index = this.getItems().indexOf(this.getCube());
                    if (index > -1) {
                        ((CCombo)this.section.getComboControl().getControl()).select(index);
                        break;
                    }
                    ((CCombo)this.section.getComboControl().getControl()).deselectAll();
                }
            }
        } else {
            this.resetCubeReference((CubeHandle)value, false);
        }
    }

    public Object load() {
        return this.getCube();
    }

    private CubeHandle getCube() {
        return this.getExtendedItemHandle().getCube();
    }

    private void resetCubeReference(CubeHandle value, boolean clearHistory) {
        try {
            this.startTrans("Reset Reference");
            CubeHandle cubeHandle = null;
            if (value != null) {
                cubeHandle = this.getExtendedItemHandle().getModuleHandle().findCube(value.getQualifiedName());
            }
            if (value == null) {
                this.getExtendedItemHandle().setCube(cubeHandle);
                new LinkedDataSetAdapter().setLinkedDataModel((ReportItemHandle)this.getExtendedItemHandle(), null);
            } else if (cubeHandle != value) {
                this.getExtendedItemHandle().setCube(null);
                new LinkedDataSetAdapter().setLinkedDataModel((ReportItemHandle)this.getExtendedItemHandle(), (Object)value.getQualifiedName());
            } else {
                new LinkedDataSetAdapter().setLinkedDataModel((ReportItemHandle)this.getExtendedItemHandle(), null);
                this.getExtendedItemHandle().setCube(cubeHandle);
            }
            if (clearHistory) {
                this.getExtendedItemHandle().getColumnBindings().clearValue();
                this.getExtendedItemHandle().getPropertyHandle("paramBindings").clearValue();
            }
            this.commit();
        }
        catch (SemanticException e) {
            this.rollback();
            ExceptionUtil.handle((Throwable)e);
        }
        this.load();
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private ExtendedItemHandle getExtendedItemHandle() {
        return (ExtendedItemHandle)DEUtil.getInputFirstElement((Object)this.input);
    }

    private void startTrans(String name) {
        this.getActionStack().startTrans(name);
    }

    private void commit() {
        this.getActionStack().commit();
    }

    private void rollback() {
        this.getActionStack().rollback();
    }

    public void setCrosstabSimpleComboSection(CrosstabBindingComboSection section) {
        this.section = section;
    }
}

